package cn.fraudmetrix.riskservice.ruledetail.parse;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.List;

public class PublicFormat implements Format {

    private final Type sourceType;
    private Convert    decoder;

    public PublicFormat(Type sourceType){
        this.sourceType = sourceType;
        decoder = getDecoder();
    }

    @Override
    public Object decode(Object json) {
        return decoder.run(json);
    }

    private Convert getDecoder() {
        // 对于基本类型，直接返回原来的数值
        if (sourceType == null) return new DecodeNothing();
        if (isPrimaryType(sourceType)) return new ConvertPrimary(sourceType);

        // 对于列表类型，需要做成JSONArray类型
        if (isListType(sourceType)) {
            Type elementType = getListElementType(sourceType);
            return new DecodeList(getProvider(), elementType);
        }

        // 其他类型，当做JavaBean来处理
        if (sourceType instanceof Class) {
            return DecodeJavaBean.create(getProvider(), (Class) sourceType);
        }

        // 未知类型
        return new DecodeNothing();
    }

    private FormatProvider getProvider() {
        return PublicFormatProvider.getInstance();
    }

    private boolean isListType(Type type) {
        Type result = getListElementType(type);
        if (result == null) return false;
        return true;
    }

    /**
     * 比如List<String>类型，就返回String
     *
     * @param type
     * @return
     */
    private Type getListElementType(Type type) {
        if (type == null) return null;
        if (!(type instanceof ParameterizedType)) return null;
        Type rawType = ((ParameterizedType) type).getRawType();
        if (rawType != List.class) return null;
        Type[] args = ((ParameterizedType) type).getActualTypeArguments();
        if (args.length != 1) return null;
        return args[0];
    }

    private boolean isPrimaryType(Type type) {
        if (type == int.class) return true;
        if (type == Integer.class) return true;
        if (type == long.class) return true;
        if (type == Long.class) return true;
        if (type == String.class) return true;
        if (type == Boolean.class) return true;
        if (type == boolean.class) return true;
        if (type == Timestamp.class) return true;
        if (type == Float.class) return true;
        if (type == float.class) return true;
        if (type == Double.class) return true;
        if (type == double.class) return true;
        return false;
    }
}
