package cn.fraudmetrix.riskservice.ruledetail.parse;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.fastjson.JSONObject;

public class PublicFieldFormat implements FieldFormat {

    private static final Log logger = LogFactory.getLog(PublicFieldFormat.class);

    private FormatProvider   format;
    private Type             fieldType;
    private String           fieldName;
    private Method           setter;

    public PublicFieldFormat(FormatProvider format, Field field){
        this.format = format;

        // 不保存静态变量
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (isStatic) return;

        // 反序列化的话都保存
        setter = getSetterMethod(field.getDeclaringClass(), field.getName(), field.getType());

        // 获取字段类型
        fieldType = field.getGenericType();

        // 获取字段的名称
        this.fieldName = field.getName();
    }

    private Method getSetterMethod(Class<?> clazz, String fieldName, Class<?> fieldType) {
        String methodName = getSetterMethodName(fieldName);
        try {
            return clazz.getMethod(methodName, fieldType);
        } catch (Exception ex) {
            logger.warn("Failed to get setter method for field: " + fieldName, ex);
            return null;
        }
    }

    @Override
    public void decodeField(JSONObject json, Object o) {
        // 检查参数
        if (json == null) return;
        if (o == null) return;
        if (setter == null) return;

        // 根据类型获取json里面的内容，如果获取失败就算了，不解码了
        Object value = json.get(underline(fieldName));
        if (value == null) return;

        // 获取到json中的内容之后，还需要进一步处理。如果处理失败，就不解码了
        Object after = format.getFormat(fieldType).decode(value);
        if (after == null) return;

        // 字段值解码成功，需要将其赋值到JavaBean中。赋值失败就不解码了
        try {
            setter.invoke(o, after);
        } catch (Exception ex) {
            logger.warn("Failed to invoke setter for " + fieldName, ex);
        }
    }

    private String getSetterMethodName(String fieldName) {
        if (fieldName == null) return null;
        if (fieldName.isEmpty()) return "set";
        return "set" + upperCaseFirst(fieldName);
    }

    private String upperCaseFirst(String fieldName) {
        String part2 = fieldName.substring(0, 1).toUpperCase();
        String part3 = fieldName.substring(1);
        return part2 + part3;
    }

    private static String underline(String str) {
        StringBuffer sb = new StringBuffer();

        if (str != null) {
            for (int i = 0; i < str.length(); i++) {
                char c = str.charAt(i);
                String s = str.substring(i, i + 1);

                // A-Z
                if (c >= 65 && c <= 90) {
                    sb.append("_").append(s.toLowerCase());
                } else {
                    sb.append(s);
                }
            }
        }

        return sb.toString();
    }
}
