/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.riskservice.object;

import com.alibaba.fastjson.JSON;

import java.io.Serializable;
import java.util.List;

/**
 * 策略详情
 *
 * @author ming.ma@fruadmetrix.cn
 */
public final class Policy implements Serializable {

    private static final long serialVersionUID = 2971731835604653516L;

    /**
     * 策略执行结果
     */
    private String policy_decision;
    /**
     * 策略模式
     */
    private String policy_mode;
    /**
     * 策略名称
     */
    private String policy_name;
    /**
     * 策略命中分数
     */
    private String policy_score;
    /**
     * 策略通用唯一标示符
     */
    private String policy_uuid;
    /**
     * 风险类型
     */
    private String risk_type;
    /**
     * 当前策略下命中的规则列表
     */
    private List<HitRule> hit_rules;

    public void setPolicy_decision(String policy_decision) {
        this.policy_decision = policy_decision;
    }

    public void setPolicy_mode(String policy_mode) {
        this.policy_mode = policy_mode;
    }

    public void setPolicy_name(String policy_name) {
        this.policy_name = policy_name;
    }

    public void setPolicy_score(String policy_score) {
        this.policy_score = policy_score;
    }

    public void setPolicy_uuid(String policy_uuid) {
        this.policy_uuid = policy_uuid;
    }

    public void setRisk_type(String risk_type) {
        this.risk_type = risk_type;
    }



    public void setHit_rules(List<HitRule> hit_rules) {
        this.hit_rules = hit_rules;
    }

    /**
     * Gets 策略通用唯一标示符.
     *
     * @return Value of 策略通用唯一标示符.
     */
    public String getPolicy_uuid() {
        return policy_uuid;
    }

    /**
     * Gets 当前策略下命中的规则列表.
     *
     * @return Value of 当前策略下命中的规则列表.
     */
    public List<HitRule> getHit_rules() {
        return hit_rules;
    }

    /**
     * Gets 策略命中分数.
     *
     * @return Value of 策略命中分数.
     */
    public String getPolicy_score() {
        return policy_score;
    }

    /**
     * Gets 风险类型.
     *
     * @return Value of 风险类型.
     */
    public String getRisk_type() {
        return risk_type;
    }

    /**
     * Gets 策略执行结果.
     *
     * @return Value of 策略执行结果.
     */
    public String getPolicy_decision() {
        return policy_decision;
    }

    /**
     * Gets 策略模式.
     *
     * @return Value of 策略模式.
     */
    public String getPolicy_mode() {
        return policy_mode;
    }

    /**
     * Gets 策略名称.
     *
     * @return Value of 策略名称.
     */
    public String getPolicy_name() {
        return policy_name;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this, true);
    }
}