/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.ruledetail.parse;

import cn.fraudmetrix.riskservice.ruledetail.parse.Convert;
import cn.fraudmetrix.riskservice.ruledetail.parse.FieldFormat;
import cn.fraudmetrix.riskservice.ruledetail.parse.FormatProvider;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecodeJavaBeanViaConstructor
implements Convert {
    private static final Log logger = LogFactory.getLog(DecodeJavaBeanViaConstructor.class);
    private final FormatProvider format;
    private final List<FieldFormat> fieldFormats;
    private final Constructor constructor;

    public DecodeJavaBeanViaConstructor(FormatProvider format, Class<?> sourceType) {
        this.format = format;
        this.constructor = this.getConstructor(sourceType);
        List<FieldFormat> fieldFormats = this.createFieldFormatsIncludeSuper(sourceType);
        this.fieldFormats = Collections.unmodifiableList(fieldFormats);
    }

    private List<FieldFormat> createFieldFormatsIncludeSuper(Class<?> clazz) {
        ArrayList<FieldFormat> result = new ArrayList<FieldFormat>();
        while (clazz != null) {
            List<FieldFormat> sub = this.createFieldFormats(clazz);
            result.addAll(sub);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List<FieldFormat> createFieldFormats(Class<?> sourceType) {
        Field[] fields = sourceType.getDeclaredFields();
        ArrayList<FieldFormat> result = new ArrayList<FieldFormat>();
        for (Field field : fields) {
            FieldFormat fieldFormat = this.format.getFieldFormat(field);
            if (fieldFormat == null) continue;
            result.add(fieldFormat);
        }
        return result;
    }

    @Override
    public Object run(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Map)) {
            return null;
        }
        JSONObject json = new JSONObject((Map)o);
        Object instance = this.newInstance();
        if (instance == null) {
            return null;
        }
        for (FieldFormat e : this.fieldFormats) {
            if (e == null) continue;
            e.decodeField(json, instance);
        }
        return instance;
    }

    private Constructor getConstructor(Class<?> sourceType) {
        try {
            Constructor<?> result = sourceType.getConstructor(new Class[0]);
            return result;
        }
        catch (Exception ex) {
            logger.warn((Object)"Failed to get constructor for JavaBean", (Throwable)ex);
            return null;
        }
    }

    private Object newInstance() {
        if (this.constructor == null) {
            return null;
        }
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            logger.warn((Object)"Failed to create JavaBean from constructor", (Throwable)ex);
            return null;
        }
    }
}

