/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.observer;

import cn.fraudmetrix.riskservice.Version;
import cn.fraudmetrix.riskservice.observer.object.InOutTime;
import cn.fraudmetrix.riskservice.observer.object.InOutTimeStats;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class ClientDataObserver
implements Observer {
    private final HttpClient httpClient;
    private final String url;
    private final String partnerCode;
    private ScheduledExecutorService peridFlushService = new ScheduledThreadPoolExecutor(1);
    private boolean isDead = false;
    InOutTimeStats inOutTimeStats = new InOutTimeStats();

    public ClientDataObserver(int flushIntervalInSeconds, HttpClient httpClient, String url, String partnerCode) {
        this.httpClient = httpClient;
        this.url = url;
        this.partnerCode = partnerCode;
        this.peridFlushService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ClientDataObserver.this.flush();
            }
        }, flushIntervalInSeconds, flushIntervalInSeconds, TimeUnit.SECONDS);
    }

    public HttpEntity buildEntity(InOutTimeStats inOutTimeStats) {
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        nameValuePairs.add(new BasicNameValuePair("averageOutTimeMillis", String.valueOf(inOutTimeStats.getAvgOutTimeMillis())));
        nameValuePairs.add(new BasicNameValuePair("maxOutTimeMillis", String.valueOf(inOutTimeStats.getMaxOutTimeMillis())));
        nameValuePairs.add(new BasicNameValuePair("minOutTimeMills", String.valueOf(inOutTimeStats.getMinOutTimeMillis())));
        nameValuePairs.add(new BasicNameValuePair("averageInTimeMillis", String.valueOf(inOutTimeStats.getAvgInTimeMillis())));
        nameValuePairs.add(new BasicNameValuePair("maxInTimeMillis", String.valueOf(inOutTimeStats.getMaxInTimeMillis())));
        nameValuePairs.add(new BasicNameValuePair("minInTimeMillis", String.valueOf(inOutTimeStats.getMinInTimeMillis())));
        nameValuePairs.add(new BasicNameValuePair("count", String.valueOf(inOutTimeStats.getCount())));
        nameValuePairs.add(new BasicNameValuePair("clientVersion", Version.getVersion()));
        nameValuePairs.add(new BasicNameValuePair("partnerCode", this.partnerCode));
        return new UrlEncodedFormEntity(nameValuePairs, Charset.defaultCharset());
    }

    public void update(Observable riskClient, Object inOutTime) {
        if (!this.isDead) {
            InOutTime clientStats = null;
            if (!(inOutTime instanceof InOutTime)) {
                return;
            }
            clientStats = (InOutTime)inOutTime;
            this.innerUpdate(clientStats);
        }
    }

    private void innerUpdate(InOutTime clientStats) {
        this.inOutTimeStats.take(clientStats.getInTimeMillis(), clientStats.getOutTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.inOutTimeStats.getCount() <= 0L) {
            return;
        }
        HttpPost httpPost = new HttpPost(this.url);
        httpPost.setEntity(this.buildEntity(this.inOutTimeStats));
        this.inOutTimeStats = new InOutTimeStats();
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException iOException) {
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
    }
}

