package cn.fraudmetrix.riskservice;

import cn.fraudmetrix.riskservice.ruledetail.ConditionDetail;
import cn.fraudmetrix.riskservice.ruledetail.RuleDetail;

import java.util.ArrayList;
import java.util.List;

public class RuleDetailResult {

    private boolean          success;
    private String           reasonCode;
    private String           reasonDesc;
    private List<RuleDetail> rules;

    public RuleDetailResult(){
    }

    public boolean getSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getReasonCode() {
        return reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getReasonDesc() {
        return reasonDesc;
    }

    public void setReasonDesc(String reasonDesc) {
        this.reasonDesc = reasonDesc;
    }

    public List<RuleDetail> getRules() {
        return rules;
    }

    public void setRules(List<RuleDetail> rules) {
        this.rules = rules;
    }

    public <T> List<T> find(Class<T> clazz) {
        if (rules == null) return new ArrayList<T>();
        if (clazz == null) return new ArrayList<T>();
        List<T> result = new ArrayList<T>();
        for (RuleDetail e : rules) {
            if (e == null) continue;
            List<ConditionDetail> conditions = e.getConditions();
            if (conditions == null) continue;
            for (ConditionDetail condition : conditions) {
                if (!clazz.isInstance(condition)) continue;
                result.add((T) condition);
            }
        }
        return result;
    }
}
