/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice.observer.object;

public class InOutTimeStats {
    private long count = 0L;
    private long maxInTimeMillis = 0L;
    private long minInTimeMillis = Long.MAX_VALUE;
    private long maxOutTimeMillis = 0L;
    private long minOutTimeMillis = Long.MAX_VALUE;
    private long totalOutTimeMillis = 0L;
    private long totalInTimeMillis = 0L;

    public void take(long inTimeMillis, long outTimeMillis) {
        ++this.count;
        this.totalOutTimeMillis += outTimeMillis;
        this.totalInTimeMillis += inTimeMillis;
        this.maxInTimeMillis = Math.max(inTimeMillis, this.maxInTimeMillis);
        this.minInTimeMillis = Math.min(inTimeMillis, this.minInTimeMillis);
        this.maxOutTimeMillis = Math.max(outTimeMillis, this.maxOutTimeMillis);
        this.minOutTimeMillis = Math.min(outTimeMillis, this.minOutTimeMillis);
    }

    public long getCount() {
        return this.count;
    }

    public long getMaxInTimeMillis() {
        return this.maxInTimeMillis;
    }

    public long getMinInTimeMillis() {
        return this.minInTimeMillis;
    }

    public long getMaxOutTimeMillis() {
        return this.maxOutTimeMillis;
    }

    public long getMinOutTimeMillis() {
        return this.minOutTimeMillis;
    }

    public long getAvgOutTimeMillis() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.totalOutTimeMillis / this.count;
    }

    public long getAvgInTimeMillis() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.totalInTimeMillis / this.count;
    }

    public String toString() {
        String out = String.format("maxIn: %d, minIn: %d, avgIn: %d \nmaxOut: %d, minOut: %d, avgOut: %d\ncount: %d", this.getMaxInTimeMillis(), this.getMinInTimeMillis(), this.getAvgInTimeMillis(), this.getMaxOutTimeMillis(), this.getMinOutTimeMillis(), this.getAvgOutTimeMillis(), this.getCount());
        return out;
    }
}

