package cn.fraudmetrix.riskservice.observer.object;

/**
 * @author kui.yuan@fraudmetrix.cn
 */
public class InOutTimeStats {
    private long count = 0;
    private long maxInTimeMillis = 0;
    private long minInTimeMillis = Long.MAX_VALUE;
    private long maxOutTimeMillis = 0;
    private long minOutTimeMillis = Long.MAX_VALUE;
    private long totalOutTimeMillis = 0;
    private long totalInTimeMillis = 0;


    /**
     * 纳入统计
     *
     * @param inTimeMillis
     * @param outTimeMillis
     */
    public void take(long inTimeMillis, long outTimeMillis) {
        count += 1;
        totalOutTimeMillis += outTimeMillis;
        totalInTimeMillis += inTimeMillis;
        maxInTimeMillis = Math.max(inTimeMillis, maxInTimeMillis);
        minInTimeMillis = Math.min(inTimeMillis, minInTimeMillis);
        maxOutTimeMillis = Math.max(outTimeMillis, maxOutTimeMillis);
        minOutTimeMillis = Math.min(outTimeMillis, minOutTimeMillis);
    }

    public long getCount() {
        return count;
    }

    public long getMaxInTimeMillis() {
        return maxInTimeMillis;
    }

    public long getMinInTimeMillis() {
        return minInTimeMillis;
    }

    public long getMaxOutTimeMillis() {
        return maxOutTimeMillis;
    }

    public long getMinOutTimeMillis() {
        return minOutTimeMillis;
    }

    public long getAvgOutTimeMillis() {
        if (count == 0) {
            return 0;
        }
        return totalOutTimeMillis / count;
    }

    public long getAvgInTimeMillis() {
        if (count == 0) {
            return 0;
        }
        return totalInTimeMillis / count;
    }

    @Override
    public String toString() {
        String out = String.format("maxIn: %d, minIn: %d, avgIn: %d \n" +
                        "maxOut: %d, minOut: %d, avgOut: %d\n" +
                        "count: %d",
                getMaxInTimeMillis(), getMinInTimeMillis(), getAvgInTimeMillis(),
                getMaxOutTimeMillis(), getMinOutTimeMillis(), getAvgOutTimeMillis(),
                getCount());
        return out;
    }
}
