/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.riskservice.object;

import com.alibaba.fastjson.JSON;

import java.io.Serializable;

/**
 * 命中规则列表
 *
 * @author ming.ma@fruadmetrix.cn
 */
public final class HitRule implements Serializable {

    private static final long serialVersionUID = 6297666052880082771L;
    /**
     * 规则编号
     */
    private String id;
    /**
     * 规则通用唯一标示符
     */
    private String uuid;
    /**
     * 规则名称
     */
    private String name;
    /**
     * 规则决策结果
     */
    private String decision;
    /**
     * 规则命中分数
     */
    private int score;
    /**
     * 父节点通用唯一标示符
     */
    private String parentUuid;

    public void setId(String id) {
        this.id = id;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDecision(String decision) {
        this.decision = decision;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void setParentUuid(String parentUuid) {
        this.parentUuid = parentUuid;
    }

    /**
     * Gets 规则命中分数.
     *
     * @return Value of 规则命中分数.
     */
    public int getScore() {
        return score;
    }

    /**
     * Gets 规则决策结果.
     *
     * @return Value of 规则决策结果.
     */
    public String getDecision() {
        return decision;
    }

    /**
     * Gets 父节点通用唯一标示符.
     *
     * @return Value of 父节点通用唯一标示符.
     */
    public String getParentUuid() {
        return parentUuid;
    }

    /**
     * Gets 规则名称.
     *
     * @return Value of 规则名称.
     */
    public String getName() {
        return name;
    }

    /**
     * Gets 规则通用唯一标示符.
     *
     * @return Value of 规则通用唯一标示符.
     */
    public String getUuid() {
        return uuid;
    }

    /**
     * Gets 规则编号.
     *
     * @return Value of 规则编号.
     */
    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this, true);
    }
}