/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.riskservice;

import cn.fraudmetrix.riskservice.object.Environment;
import cn.fraudmetrix.riskservice.object.RiskResult;
import cn.fraudmetrix.riskservice.observer.ClientDataObserver;
import cn.fraudmetrix.riskservice.observer.object.InOutTime;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiskServiceClient
extends Observable {
    private static final Log log = LogFactory.getLog(RiskServiceClient.class);
    private String apiUrl;
    private static final String DEFAULT_CHARSET = "utf-8";
    private NameValuePair partnerCode;
    private String charset;
    private CloseableHttpClient httpClient;
    private static final RiskServiceClient instance = new RiskServiceClient();
    private static boolean inited;

    private RiskServiceClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset) {
        RiskServiceClient riskServiceClient = instance;
        synchronized (riskServiceClient) {
            if (inited) {
                return;
            }
            inited = true;
        }
        Asserts.notBlank((CharSequence)partnerCode, (String)"partnerCode");
        Asserts.check((connectTimeout >= 500 ? 1 : 0) != 0, (String)"connectTimeout must >= 500ms.");
        Asserts.check((readTimeout >= 500 ? 1 : 0) != 0, (String)"readTimeout must >= 500ms.");
        Asserts.check((maxConnection > 0 ? 1 : 0) != 0, (String)"maxConnection must > 0.");
        if (null == environment) {
            environment = Environment.PRODUCT;
        }
        this.apiUrl = environment.getApiUrl();
        this.partnerCode = new BasicNameValuePair("partner_code", partnerCode);
        this.charset = null == charset ? DEFAULT_CHARSET : charset;
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setMaxTotal(maxConnection);
        connMgr.setDefaultMaxPerRoute(maxConnection);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(connectTimeout);
        configBuilder.setSocketTimeout(readTimeout);
        configBuilder.setConnectionRequestTimeout(500);
        configBuilder.setStaleConnectionCheckEnabled(true);
        RequestConfig requestConfig = configBuilder.build();
        this.httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    RiskServiceClient.this.execute("heartbeat", "heartbeat", null);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e);
                        return;
                    }
                }
            }
        }, "RiskServiceClient Heartbeat Thread").start();
        if (environment == Environment.PRODUCT) {
            ClientDataObserver observer = new ClientDataObserver(60, (HttpClient)this.httpClient, "https://api.fraudmetrix.cn/clientDataCollectService.json", partnerCode);
            this.addObserver(observer);
        }
    }

    public static RiskServiceClient getInstance(String partnerCode) {
        return RiskServiceClient.getInstance(partnerCode, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment) {
        return RiskServiceClient.getInstance(partnerCode, environment, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, String charset) {
        return RiskServiceClient.getInstance(partnerCode, environment, 1000, 1000, 50, charset);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, String charset) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, 50, charset);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection) {
        return RiskServiceClient.getInstance(partnerCode, environment, connectTimeout, readTimeout, maxConnection, null);
    }

    public static RiskServiceClient getInstance(String partnerCode, Environment environment, int connectTimeout, int readTimeout, int maxConnection, String charset) {
        instance.init(partnerCode, environment, connectTimeout, readTimeout, maxConnection, charset);
        return instance;
    }

    private HttpEntity buildRequestEntity(String secretKey, String eventId, Map<String, String> params) {
        ArrayList<Object> nameValuePairs = new ArrayList<Object>();
        nameValuePairs.add(this.partnerCode);
        nameValuePairs.add(new BasicNameValuePair("secret_key", secretKey));
        nameValuePairs.add(new BasicNameValuePair("event_id", eventId));
        if (null != params) {
            for (String key : params.keySet()) {
                nameValuePairs.add(new BasicNameValuePair(key, params.get(key)));
            }
        }
        return new UrlEncodedFormEntity(nameValuePairs, Charset.forName(this.charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RiskResult execute(String secretKey, String eventId, Map<String, String> params) {
        RiskResult riskResult = null;
        HttpPost httpPost = new HttpPost(this.apiUrl);
        CloseableHttpResponse response = null;
        try {
            httpPost.setEntity(this.buildRequestEntity(secretKey, eventId, params));
            long requestStartTime = System.currentTimeMillis();
            response = this.httpClient.execute((HttpUriRequest)httpPost);
            long requestEndTime = System.currentTimeMillis();
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn((Object)("execute failed, response status: " + statusCode));
                RiskResult riskResult2 = null;
                return riskResult2;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                log.warn((Object)"execute failed, response output is null!");
                RiskResult riskResult3 = null;
                return riskResult3;
            }
            String result = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
            result = result.trim();
            log.debug((Object)("execute result: " + result));
            riskResult = (RiskResult)JSON.parseObject((String)result, RiskResult.class);
            try {
                long outCost = requestEndTime - requestStartTime;
                int inTime = riskResult.getSpend_time();
                InOutTime inOutTime = new InOutTime(inTime, outCost);
                this.setChanged();
                this.notifyObservers(inOutTime);
                return riskResult;
            }
            catch (Exception ignored) {
                // empty catch block
                return riskResult;
            }
        }
        catch (Exception e) {
            if ("heartbeat".equals(secretKey)) return riskResult;
            log.error((Object)"execute throw exception, details: ", (Throwable)e);
            riskResult = RiskResult.failedWithReason("000:" + e.toString());
            return riskResult;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException ignored) {}
            }
        }
    }

    private SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        }
        catch (GeneralSecurityException e) {
            log.error((Object)e);
        }
        return sslsf;
    }
}

