/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.cloudservice.utils;

import cn.fraudmetrix.cloudservice.annotation.FormParam;
import cn.fraudmetrix.cloudservice.annotation.HeaderParam;
import cn.fraudmetrix.cloudservice.annotation.QueryParam;
import cn.fraudmetrix.cloudservice.utils.BeanUtils;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class HttpUtils {
    public static HttpParam diversion(Map<BeanUtils.AnnotationValue, Object> params) {
        ArrayList<String> query = new ArrayList<String>();
        ArrayList<NameValuePair> form = new ArrayList<NameValuePair>();
        ArrayList<Header> header = new ArrayList<Header>();
        for (Map.Entry<BeanUtils.AnnotationValue, Object> param : params.entrySet()) {
            BeanUtils.AnnotationValue annotationValue = param.getKey();
            if (annotationValue.getAnnotation() instanceof QueryParam) {
                query.add(annotationValue.getValue() + "=" + String.valueOf(param.getValue()));
            }
            if (annotationValue.getAnnotation() instanceof FormParam) {
                form.add((NameValuePair)new BasicNameValuePair(annotationValue.getValue(), String.valueOf(param.getValue())));
            }
            if (!(annotationValue.getAnnotation() instanceof HeaderParam)) continue;
            header.add((Header)new BasicHeader(annotationValue.getValue(), String.valueOf(param.getValue())));
        }
        return new HttpParam(query, form, header);
    }

    public static Header[] buildRequestHeader(HttpParam param) {
        List<Header> headers = param.getHeaderParam();
        return headers.toArray(new Header[headers.size()]);
    }

    public static HttpEntity buildRequestEntity(HttpParam param, Charset charset) {
        return new UrlEncodedFormEntity(param.getFormParam(), charset);
    }

    public static URI buildRequestUri(String apiUrl, String path, HttpParam param) {
        StringBuilder builder = new StringBuilder();
        builder.append(apiUrl).append(path);
        if (!param.getQueryParam().isEmpty()) {
            builder.append("?").append(StringUtils.join(param.getQueryParam(), (String)"&"));
        }
        return URI.create(builder.toString());
    }

    public static List<NameValuePair> transformParam(Map<String, String> parameter) {
        ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>(parameter.size());
        for (Map.Entry<String, String> entry : parameter.entrySet()) {
            nameValuePairList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return nameValuePairList;
    }

    public static class HttpParam {
        List<String> queryParam;
        List<NameValuePair> formParam;
        List<Header> headerParam;

        public HttpParam(List<String> queryParam, List<NameValuePair> formParam, List<Header> headerParam) {
            this.queryParam = queryParam;
            this.formParam = formParam;
            this.headerParam = headerParam;
        }

        public List<String> getQueryParam() {
            return this.queryParam;
        }

        public void setQueryParam(List<String> queryParam) {
            this.queryParam = queryParam;
        }

        public List<NameValuePair> getFormParam() {
            return this.formParam;
        }

        public void setFormParam(List<NameValuePair> formParam) {
            this.formParam = formParam;
        }

        public List<Header> getHeaderParam() {
            return this.headerParam;
        }

        public void setHeaderParam(List<Header> headerParam) {
            this.headerParam = headerParam;
        }
    }
}

