/*
 * Decompiled with CFR 0.152.
 */
package cn.fraudmetrix.cloudservice;

import cn.fraudmetrix.cloudservice.annotation.method.HttpMethod;
import cn.fraudmetrix.cloudservice.constant.Environment;
import cn.fraudmetrix.cloudservice.request.Request;
import cn.fraudmetrix.cloudservice.request.account.AccountRequest;
import cn.fraudmetrix.cloudservice.response.Response;
import cn.fraudmetrix.cloudservice.response.account.AccountResponse;
import cn.fraudmetrix.cloudservice.utils.BeanUtils;
import cn.fraudmetrix.cloudservice.utils.HttpUtils;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;

public class CloudServiceClient {
    private static final Log logger = LogFactory.getLog(CloudServiceClient.class);
    private Builder builder;
    private CloseableHttpClient httpClient;

    private CloudServiceClient(Builder builder) {
        this.httpClient = this.createHttpClient(builder);
        this.builder = builder;
    }

    private CloseableHttpClient createHttpClient(Builder builder) {
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();
        connMgr.setMaxTotal(builder.maxConnection);
        connMgr.setDefaultMaxPerRoute(builder.maxConnection);
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(builder.connectTimeout);
        configBuilder.setSocketTimeout(builder.readTimeout);
        configBuilder.setConnectionRequestTimeout(500);
        configBuilder.setStaleConnectionCheckEnabled(true);
        RequestConfig requestConfig = configBuilder.build();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.createSSLConnSocketFactory()).setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
    }

    public <T extends Response> T execute(Request request, Class<T> clazz) throws HttpException {
        request.setPartnerCode(this.builder.partnerCode);
        request.setPartnerKey(this.builder.partnerKey);
        Map<BeanUtils.AnnotationValue, Object> params = BeanUtils.parseParam(request);
        HttpUtils.HttpParam httpParam = HttpUtils.diversion(params);
        String path = BeanUtils.parsePath(request);
        URI uri = HttpUtils.buildRequestUri(this.builder.apiUrl, path, httpParam);
        HttpMethod method = BeanUtils.parseMethod(request);
        switch (method.value()) {
            case "GET": {
                return this.doHttpRequest((HttpUriRequest)new HttpGet(uri), httpParam, clazz);
            }
            case "DELETE": {
                return this.doHttpRequest((HttpUriRequest)new HttpDelete(uri), httpParam, clazz);
            }
            case "POST": {
                return this.doHttpRequestWithEntity((HttpEntityEnclosingRequestBase)new HttpPost(uri), httpParam, clazz);
            }
            case "PUT": {
                return this.doHttpRequestWithEntity((HttpEntityEnclosingRequestBase)new HttpPut(uri), httpParam, clazz);
            }
        }
        throw new HttpException("execute failed, method not allow");
    }

    public AccountResponse execute(AccountRequest request) throws HttpException {
        request.setPartnerCode(this.builder.partnerCode);
        request.setSecretKey(this.builder.partnerKey);
        Map<BeanUtils.AnnotationValue, Object> params = BeanUtils.parseParam(request);
        HttpUtils.HttpParam httpParam = HttpUtils.diversion(params);
        String path = BeanUtils.parsePath(request);
        URI uri = HttpUtils.buildRequestUri(this.builder.apiUrl, path, httpParam);
        httpParam.setFormParam(HttpUtils.transformParam(request.getParameters()));
        return this.doHttpRequestWithEntity((HttpEntityEnclosingRequestBase)new HttpPost(uri), httpParam, AccountResponse.class);
    }

    public <T extends Response> T doHttpRequestWithEntity(HttpEntityEnclosingRequestBase request, HttpUtils.HttpParam httpParam, Class<T> clazz) throws HttpException {
        request.setEntity(HttpUtils.buildRequestEntity(httpParam, this.builder.charset));
        return this.doHttpRequest((HttpUriRequest)request, httpParam, clazz);
    }

    public <T extends Response> T doHttpRequest(HttpUriRequest request, HttpUtils.HttpParam httpParam, Class<T> clazz) throws HttpException {
        Response response;
        request.setHeaders(HttpUtils.buildRequestHeader(httpParam));
        CloseableHttpResponse response2 = null;
        try {
            response2 = this.httpClient.execute(request);
            int statusCode = response2.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new HttpException("execute failed, response status: " + statusCode);
            }
            HttpEntity entity = response2.getEntity();
            if (entity == null) {
                throw new HttpException("execute failed, response output is null!");
            }
            String result = EntityUtils.toString((HttpEntity)entity, (Charset)this.builder.charset);
            response = (Response)JSON.parseObject((String)result, clazz);
        }
        catch (IOException | HttpException e) {
            throw new HttpException("execute failed. ", e);
        }
        finally {
            if (response2 != null) {
                try {
                    EntityUtils.consume((HttpEntity)response2.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
        return (T)response;
    }

    private SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        }
        catch (GeneralSecurityException e) {
            logger.error((Object)e);
        }
        return sslsf;
    }

    public static class Builder {
        private String partnerCode;
        private String partnerKey;
        private String apiUrl = Environment.PRODUCT.getApiUrl();
        private Charset charset = Charset.forName("UTF-8");
        private int connectTimeout = 1000;
        private int readTimeout = 1000;
        private int maxConnection = 50;

        public Builder charset(String charset) {
            Asserts.notNull((Object)charset, (String)"Charset");
            this.charset = Charset.forName(charset);
            return this;
        }

        public Builder environment(Environment environment) {
            Asserts.notNull((Object)((Object)environment), (String)"Environment");
            this.apiUrl = environment.getApiUrl();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            Asserts.check((connectTimeout >= 500 ? 1 : 0) != 0, (String)"connectTimeout must >= 500ms.");
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            Asserts.check((readTimeout >= 500 ? 1 : 0) != 0, (String)"readTimeout must >= 500ms.");
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder maxConnection(int maxConnection) {
            Asserts.check((maxConnection > 0 ? 1 : 0) != 0, (String)"maxConnection must > 0.");
            this.maxConnection = maxConnection;
            return this;
        }

        public CloudServiceClient build(String partnerCode, String partnerKey) {
            Asserts.notBlank((CharSequence)partnerCode, (String)"partnerCode");
            Asserts.notBlank((CharSequence)partnerKey, (String)"partnerKey");
            this.partnerCode = partnerCode;
            this.partnerKey = partnerKey;
            return new CloudServiceClient(this);
        }
    }
}

