/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.utils;

import cn.fraudmetrix.cloudservice.annotation.FormParam;
import cn.fraudmetrix.cloudservice.annotation.HeaderParam;
import cn.fraudmetrix.cloudservice.annotation.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * HttpUtils
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 18:57
 */
public class HttpUtils {

    public static HttpParam diversion(Map<BeanUtils.AnnotationValue, Object> params) {
        List<String> query = new ArrayList<>();
        List<NameValuePair> form = new ArrayList<>();
        List<Header> header = new ArrayList<>();

        for (Map.Entry<BeanUtils.AnnotationValue, Object> param : params.entrySet()) {
            BeanUtils.AnnotationValue annotationValue = param.getKey();
            if (annotationValue.getAnnotation() instanceof QueryParam) {
                query.add(annotationValue.getValue() + "=" + String.valueOf(param.getValue()));
            }
            if (annotationValue.getAnnotation() instanceof FormParam) {
                form.add(new BasicNameValuePair(annotationValue.getValue(), String.valueOf(param.getValue())));
            }
            if (annotationValue.getAnnotation() instanceof HeaderParam) {
                header.add(new BasicHeader(annotationValue.getValue(), String.valueOf(param.getValue())));
            }
        }

        return new HttpParam(query, form, header);
    }

    public static Header[] buildRequestHeader(HttpParam param) {
        List<Header> headers = param.getHeaderParam();
        return headers.toArray(new Header[headers.size()]);
    }

    public static HttpEntity buildRequestEntity(HttpParam param, String charset) {
        return new UrlEncodedFormEntity(param.getFormParam(), Charset.forName(charset));
    }

    public static URI buildRequestUri(String apiUrl, String path, HttpParam param) {
        StringBuilder builder = new StringBuilder();
        builder.append(apiUrl).append(path);
        if (!param.getQueryParam().isEmpty()) {
            builder.append("?").append(StringUtils.join(param.getQueryParam(), "&"));
        }
        return URI.create(builder.toString());
    }

    public static class HttpParam {

        List<String>        queryParam;
        List<NameValuePair> formParam;
        List<Header>        headerParam;

        public HttpParam(List<String> queryParam, List<NameValuePair> formParam, List<Header> headerParam){
            this.queryParam = queryParam;
            this.formParam = formParam;
            this.headerParam = headerParam;
        }

        public List<String> getQueryParam() {
            return queryParam;
        }

        public void setQueryParam(List<String> queryParam) {
            this.queryParam = queryParam;
        }

        public List<NameValuePair> getFormParam() {
            return formParam;
        }

        public void setFormParam(List<NameValuePair> formParam) {
            this.formParam = formParam;
        }

        public List<Header> getHeaderParam() {
            return headerParam;
        }

        public void setHeaderParam(List<Header> headerParam) {
            this.headerParam = headerParam;
        }
    }
}
