/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.utils;

import cn.fraudmetrix.cloudservice.annotation.Param;
import cn.fraudmetrix.cloudservice.annotation.Path;
import cn.fraudmetrix.cloudservice.annotation.method.GET;
import cn.fraudmetrix.cloudservice.annotation.method.HttpMethod;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * BeanUtils
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 11:16
 */
public class BeanUtils {

    public static String parsePath(Object obj) {
        Class<?> clazz = obj.getClass();
        Path annotation = clazz.getAnnotation(Path.class);
        if (annotation == null) return "/";
        return annotation.value();
    }

    public static HttpMethod parseMethod(Object obj) {
        Class<?> clazz = obj.getClass();
        Annotation[] annotations = clazz.getAnnotations();
        for (int i = 0; i < annotations.length; i++) {
            HttpMethod httpMethod = annotations[i].annotationType().getAnnotation(HttpMethod.class);
            if (httpMethod != null) {
                return httpMethod;
            }
        }

        return GET.class.getAnnotation(HttpMethod.class);
    }

    public static Map<AnnotationValue, Object> parseParam(Object obj) {
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        Map<AnnotationValue, Object> params = new HashMap<>();
        for (int i = 0; i < methods.length; i++) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get")) continue;

            AnnotationValue annotationValue = getAnnotationValue(method.getAnnotations());
            if (annotationValue == null) {
                String fieldName = getFieldByMethod(methodName);
                try {
                    annotationValue = getAnnotationValue(getDeclaredField(clazz, fieldName).getAnnotations());
                } catch (NoSuchFieldException e) {
                    continue;
                }
                if (annotationValue == null) continue;
            }

            try {
                Object value = method.invoke(obj);
                if (value == null) continue;

                if (value instanceof List) {
                    params.putAll(parseListParam(annotationValue, (List<Object>) value));
                } else {
                    params.put(annotationValue, String.valueOf(value));
                }
            } catch (IllegalAccessException | InvocationTargetException e) {
                // do nothing
            }
        }

        return params;
    }

    private static Map<AnnotationValue, Object> parseListParam(AnnotationValue key, List<Object> list) {
        Map<AnnotationValue, Object> params = new HashMap<>();
        for (int j = 0; j < list.size(); j++) {
            Map<AnnotationValue, Object> p = parseParam(list.get(j));
            for (Map.Entry<AnnotationValue, Object> e : p.entrySet()) {
                String newValue = key.getValue() + (j + 1) + e.getKey().getValue();
                AnnotationValue newKey = new AnnotationValue(key.getAnnotation(), newValue);
                params.put(newKey, e.getValue());
            }
        }

        return params;
    }

    private static String getFieldByMethod(String method) {
        String name = method.substring(3);
        String first = String.valueOf(name.charAt(0)).toLowerCase();
        return first + method.substring(4);
    }

    private static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        } catch (NoSuchFieldException e) {
            clazz = clazz.getSuperclass();
            if (clazz == null) throw e;
            return getDeclaredField(clazz, name);
        }
    }

    private static AnnotationValue getAnnotationValue(Annotation[] annotations) {
        for (int i = 0; i < annotations.length; i++) {
            Param param = annotations[i].annotationType().getAnnotation(Param.class);
            if (param == null) continue;
            try {
                Method method = annotations[i].annotationType().getDeclaredMethod("value");
                Object value = method.invoke(annotations[i]);
                if (value != null) {
                    return new AnnotationValue(annotations[i], String.valueOf(value));
                }
            } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
                // do nothing
            }
        }
        return null;
    }

    public static class AnnotationValue {

        private Annotation annotation;
        private String     value;

        public AnnotationValue(Annotation annotation, String value){
            setAnnotation(annotation);
            setValue(value);
        }

        public Annotation getAnnotation() {
            return annotation;
        }

        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
