/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.response.preloan;

import cn.fraudmetrix.cloudservice.object.response.GeoIp;
import cn.fraudmetrix.cloudservice.object.response.RiskItem;
import cn.fraudmetrix.cloudservice.response.Response;
import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;
import java.util.Map;

/**
 * ReportResponse 贷前准入报告
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 10:35
 */
public class ReportResponse extends Response {

    /**
     * 准入风险分数
     */
    @JSONField(name = "final_score")
    private Integer                finalScore;
    /**
     * 准入风险结果
     */
    @JSONField(name = "final_decision")
    private String                 finalDecision;
    /**
     * 准入报告编号
     */
    @JSONField(name = "report_id")
    private String                 reportId;
    /**
     * 扫描时间
     */
    @JSONField(name = "apply_time")
    private Long                   applyTime;
    /**
     * 报告时间
     */
    @JSONField(name = "report_time")
    private Long                   reportTime;
    /**
     * 设备环境信息
     */
    @JSONField(name = "device_info")
    private Map<String, String>    deviceInfo;
    /**
     * 地理位置信息
     */
    @JSONField(name = "geo_ip")
    private GeoIp geoIp;
    /**
     * 真是地理位置信息
     */
    @JSONField(name = "geo_trueip")
    private GeoIp geoTrueIp;
    /**
     * 检查风险项
     */
    @JSONField(name = "risk_items")
    private List<RiskItem> riskItems;

    public Integer getFinalScore() {
        return finalScore;
    }

    public void setFinalScore(Integer finalScore) {
        this.finalScore = finalScore;
    }

    public String getFinalDecision() {
        return finalDecision;
    }

    public void setFinalDecision(String finalDecision) {
        this.finalDecision = finalDecision;
    }

    public String getReportId() {
        return reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Long getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Long applyTime) {
        this.applyTime = applyTime;
    }

    public Long getReportTime() {
        return reportTime;
    }

    public void setReportTime(Long reportTime) {
        this.reportTime = reportTime;
    }

    public Map<String, String> getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(Map<String, String> deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public GeoIp getGeoIp() {
        return geoIp;
    }

    public void setGeoIp(GeoIp geoIp) {
        this.geoIp = geoIp;
    }

    public GeoIp getGeoTrueIp() {
        return geoTrueIp;
    }

    public void setGeoTrueIp(GeoIp geoTrueIp) {
        this.geoTrueIp = geoTrueIp;
    }

    public List<RiskItem> getRiskItems() {
        return riskItems;
    }

    public void setRiskItems(List<RiskItem> riskItems) {
        this.riskItems = riskItems;
    }
}
