/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.response.postloan;

import cn.fraudmetrix.cloudservice.object.response.Track;
import cn.fraudmetrix.cloudservice.response.Response;
import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;

/**
 * ReportResponse 贷后信修查询
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 16:28
 */
public class ReportResponse extends Response {

    /**
     * 信修报告编号
     */
    @JSONField(name = "report_id")
    private String       report_id;
    /**
     * 扫描时间:UNIX时间戳,毫秒级
     */
    @JSONField(name = "repair_time")
    private Long         repair_time;
    /**
     * 报告时间:UNIX时间戳,毫秒级
     */
    @JSONField(name = "report_time")
    private Long         report_time;
    /**
     * 通讯手机列表
     */
    @JSONField(name = "contact_mobile_list")
    private List<String> contactMobile;
    /**
     * 通讯邮件列表
     */
    @JSONField(name = "contact_email_list")
    private List<String> contactEmail;
    /**
     * 通讯QQ列表
     */
    @JSONField(name = "contact_qq_list")
    private List<String> contactQQ;
    /**
     * 通讯陌陌列表
     */
    @JSONField(name = "contact_momo_list")
    private List<String> contactMomo;
    /**
     * 通讯微信列表
     */
    @JSONField(name = "contact_weixin_list")
    private List<String> contactWeixin;
    /**
     * 工作地址列表
     */
    @JSONField(name = "addr_com_list")
    private List<String> addressCompany;
    /**
     * 家庭地址列表
     */
    @JSONField(name = "addr_home_list")
    private List<String> addressHome;
    /**
     * 收货地址列表
     */
    @JSONField(name = "addr_delivery_list")
    private List<String> addressDelivery;
    /**
     * 亲属手机列表
     */
    @JSONField(name = "relatives_mobile_list")
    private List<String> relativesMobile;
    /**
     * 亲属qq列表
     */
    @JSONField(name = "relatives_qq_list")
    private List<String> relativesQQ;
    /**
     * 亲属邮箱列表
     */
    @JSONField(name = "relatives_email_list")
    private List<String> relativesEmail;
    /**
     * 同事手机列表
     */
    @JSONField(name = "colleague_mobile_list")
    private List<String> colleagueMobile;
    /**
     * 同事qq列表
     */
    @JSONField(name = "colleague_qq_list")
    private List<String> colleagueQQ;
    /**
     * 同事邮箱列表
     */
    @JSONField(name = "colleague_email_list")
    private List<String> colleagueEmail;
    /**
     * 其它联系人手机列表
     */
    @JSONField(name = "others_mobile_list")
    private List<String> othersMobilet;
    /**
     * 其它联系人qq列表
     */
    @JSONField(name = "others_qq_list")
    private List<String> othersQQ;
    /**
     * 其它联系人邮箱列表
     */
    @JSONField(name = "others_email_list")
    private List<String> othersEmail;
    /**
     * 根据手机修复，互联网络活动痕迹
     */
    @JSONField(name = "track_mobile_list")
    private List<Track>  trackMobile;
    /**
     * 根据身份证修复，互联网活动痕迹
     */
    @JSONField(name = "track_idnumber_list")
    private List<Track>  trackIdNumber;
    /**
     * 根据邮箱修复，互联网活动痕迹
     */
    @JSONField(name = "track_email_list")
    private List<Track>  trackEmail;

    public String getReport_id() {
        return report_id;
    }

    public void setReport_id(String report_id) {
        this.report_id = report_id;
    }

    public Long getRepair_time() {
        return repair_time;
    }

    public void setRepair_time(Long repair_time) {
        this.repair_time = repair_time;
    }

    public Long getReport_time() {
        return report_time;
    }

    public void setReport_time(Long report_time) {
        this.report_time = report_time;
    }

    public List<String> getContactMobile() {
        return contactMobile;
    }

    public void setContactMobile(List<String> contactMobile) {
        this.contactMobile = contactMobile;
    }

    public List<String> getContactEmail() {
        return contactEmail;
    }

    public void setContactEmail(List<String> contactEmail) {
        this.contactEmail = contactEmail;
    }

    public List<String> getContactQQ() {
        return contactQQ;
    }

    public void setContactQQ(List<String> contactQQ) {
        this.contactQQ = contactQQ;
    }

    public List<String> getContactMomo() {
        return contactMomo;
    }

    public void setContactMomo(List<String> contactMomo) {
        this.contactMomo = contactMomo;
    }

    public List<String> getContactWeixin() {
        return contactWeixin;
    }

    public void setContactWeixin(List<String> contactWeixin) {
        this.contactWeixin = contactWeixin;
    }

    public List<String> getAddressCompany() {
        return addressCompany;
    }

    public void setAddressCompany(List<String> addressCompany) {
        this.addressCompany = addressCompany;
    }

    public List<String> getAddressHome() {
        return addressHome;
    }

    public void setAddressHome(List<String> addressHome) {
        this.addressHome = addressHome;
    }

    public List<String> getAddressDelivery() {
        return addressDelivery;
    }

    public void setAddressDelivery(List<String> addressDelivery) {
        this.addressDelivery = addressDelivery;
    }

    public List<String> getRelativesMobile() {
        return relativesMobile;
    }

    public void setRelativesMobile(List<String> relativesMobile) {
        this.relativesMobile = relativesMobile;
    }

    public List<String> getRelativesQQ() {
        return relativesQQ;
    }

    public void setRelativesQQ(List<String> relativesQQ) {
        this.relativesQQ = relativesQQ;
    }

    public List<String> getRelativesEmail() {
        return relativesEmail;
    }

    public void setRelativesEmail(List<String> relativesEmail) {
        this.relativesEmail = relativesEmail;
    }

    public List<String> getColleagueMobile() {
        return colleagueMobile;
    }

    public void setColleagueMobile(List<String> colleagueMobile) {
        this.colleagueMobile = colleagueMobile;
    }

    public List<String> getColleagueQQ() {
        return colleagueQQ;
    }

    public void setColleagueQQ(List<String> colleagueQQ) {
        this.colleagueQQ = colleagueQQ;
    }

    public List<String> getColleagueEmail() {
        return colleagueEmail;
    }

    public void setColleagueEmail(List<String> colleagueEmail) {
        this.colleagueEmail = colleagueEmail;
    }

    public List<String> getOthersMobilet() {
        return othersMobilet;
    }

    public void setOthersMobilet(List<String> othersMobilet) {
        this.othersMobilet = othersMobilet;
    }

    public List<String> getOthersQQ() {
        return othersQQ;
    }

    public void setOthersQQ(List<String> othersQQ) {
        this.othersQQ = othersQQ;
    }

    public List<String> getOthersEmail() {
        return othersEmail;
    }

    public void setOthersEmail(List<String> othersEmail) {
        this.othersEmail = othersEmail;
    }

    public List<Track> getTrackMobile() {
        return trackMobile;
    }

    public void setTrackMobile(List<Track> trackMobile) {
        this.trackMobile = trackMobile;
    }

    public List<Track> getTrackIdNumber() {
        return trackIdNumber;
    }

    public void setTrackIdNumber(List<Track> trackIdNumber) {
        this.trackIdNumber = trackIdNumber;
    }

    public List<Track> getTrackEmail() {
        return trackEmail;
    }

    public void setTrackEmail(List<Track> trackEmail) {
        this.trackEmail = trackEmail;
    }
}
