/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.request.realname;

import cn.fraudmetrix.cloudservice.annotation.FormParam;
import cn.fraudmetrix.cloudservice.annotation.method.POST;
import cn.fraudmetrix.cloudservice.annotation.Path;
import cn.fraudmetrix.cloudservice.constant.RealNameType;
import cn.fraudmetrix.cloudservice.request.Request;

/**
 * CheckRequest 实名认证接口
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 17:24
 */
@Path("/real_name/check")
@POST
public class CheckRequest extends Request {

    /**
     * 身份证号码
     */
    @FormParam("id_number")
    private String       idNumber;
    /**
     * 姓名
     */
    @FormParam("name")
    private String       name;
    /**
     * 认证类型
     */
    @FormParam("type")
    private RealNameType type;
    /**
     * 图像信息
     */
    @FormParam("image")
    private String       image;

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RealNameType getType() {
        return type;
    }

    public void setType(RealNameType type) {
        this.type = type;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }
}
