/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.request.preloan;

import cn.fraudmetrix.cloudservice.annotation.FormParam;
import cn.fraudmetrix.cloudservice.annotation.Path;
import cn.fraudmetrix.cloudservice.annotation.QueryParam;
import cn.fraudmetrix.cloudservice.annotation.method.POST;
import cn.fraudmetrix.cloudservice.constant.Diploma;
import cn.fraudmetrix.cloudservice.constant.Industry;
import cn.fraudmetrix.cloudservice.constant.Marriage;
import cn.fraudmetrix.cloudservice.constant.Occupation;
import cn.fraudmetrix.cloudservice.object.request.Contact;
import cn.fraudmetrix.cloudservice.request.Request;

import java.util.List;

/**
 * ApplyRequest 贷前申请准入提交
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 09:39
 */
@Path("/preloan/apply")
@POST
public class ApplyRequest extends Request {

    /**
     * 合作方应用名
     */
    @QueryParam("app_name")
    private String        appName;
    /**
     * 贷款金额，单位是人民币元
     */
    @FormParam("loan_amount")
    private Double        loanAmount;
    /**
     * 贷款期限，单位月
     */
    @FormParam("loan_term")
    private Integer       loanTerm;
    /**
     * 贷款日期，格式yyyy-MM-dd，默认当前日期
     */
    @FormParam("loan_date")
    private String        loanDate;
    /**
     * 姓名，必填项
     */
    @FormParam("name")
    private String        name;
    /**
     * 身份证号码，必填项
     */
    @FormParam("id_number")
    private String        idNumber;
    /**
     * 手机号码，必填项
     */
    @FormParam("mobile")
    private String        mobile;
    /**
     * 座机号码，格式(区号+号码)0571-1111111
     */
    @FormParam("phone")
    private String        phone;
    /**
     * 邮箱，推荐填写
     */
    @FormParam("email")
    private String        email;
    /**
     * QQ号码，推荐填写
     */
    @FormParam("qq")
    private String        qq;
    /**
     * 银行卡号，推荐填写
     */
    @FormParam("card_number")
    private String        cardNumber;
    /**
     * 学历
     */
    @FormParam("diploma")
    private Diploma       diploma;
    /**
     * 婚姻情况
     */
    @FormParam("marriage")
    private Marriage      marriage;
    /**
     * 户籍地址，xxx省xxx市xxx县xxx镇xxx村xxx组xxx号
     */
    @FormParam("registered_address")
    private String        registeredAddress;
    /**
     * 家庭地址，xxx省xxx市xxx区xxx苑xxx幢xxx单元xxx室
     */
    @FormParam("home_address")
    private String        homeAddress;
    /**
     * 工作单位
     */
    @FormParam("company_name")
    private String        companyName;
    /**
     * 单位地址，xxx省xxx市xxx区xxx路xxx号xxx园xxx号楼xxx室
     */
    @FormParam("company_address")
    private String        companyAddress;
    /**
     * 通讯地址，xxx省xxx市xxx区xxx苑xxx幢xxx单元xxx室
     */
    @FormParam("contact_address")
    private String        contactAddress;
    /**
     * 所属行业
     */
    @FormParam("industry")
    private Industry      industry;
    /**
     * 职位
     */
    @FormParam("occupation")
    private Occupation    occupation;
    /**
     * 是否曾跨平台借款
     */
    @FormParam("is_cross_loan")
    private Boolean       isCrossLoan;
    /**
     * 是否通过实名认证
     */
    @FormParam("is_id_checked")
    private Boolean       isIdChecked;
    /**
     * 关联联系人
     */
    @FormParam("contact")
    private List<Contact> contacts;
    /**
     * IP地址
     */
    @FormParam("ip_address")
    private String        ipAddress;
    /**
     * 同盾设备指纹网页端
     */
    @FormParam("token_id")
    private String        tokenId;
    /**
     * 同盾设备指纹移动端
     */
    @FormParam("black_box")
    private String        blackBox;

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Double getLoanAmount() {
        return loanAmount;
    }

    public void setLoanAmount(Double loanAmount) {
        this.loanAmount = loanAmount;
    }

    public Integer getLoanTerm() {
        return loanTerm;
    }

    public void setLoanTerm(Integer loanTerm) {
        this.loanTerm = loanTerm;
    }

    public String getLoanDate() {
        return loanDate;
    }

    public void setLoanDate(String loanDate) {
        this.loanDate = loanDate;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public Diploma getDiploma() {
        return diploma;
    }

    public void setDiploma(Diploma diploma) {
        this.diploma = diploma;
    }

    public Marriage getMarriage() {
        return marriage;
    }

    public void setMarriage(Marriage marriage) {
        this.marriage = marriage;
    }

    public String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public String getHomeAddress() {
        return homeAddress;
    }

    public void setHomeAddress(String homeAddress) {
        this.homeAddress = homeAddress;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyAddress() {
        return companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getContactAddress() {
        return contactAddress;
    }

    public void setContactAddress(String contactAddress) {
        this.contactAddress = contactAddress;
    }

    public Industry getIndustry() {
        return industry;
    }

    public void setIndustry(Industry industry) {
        this.industry = industry;
    }

    public Occupation getOccupation() {
        return occupation;
    }

    public void setOccupation(Occupation occupation) {
        this.occupation = occupation;
    }

    public Boolean getIsCrossLoan() {
        return isCrossLoan;
    }

    public void setIsCrossLoan(Boolean isCrossLoan) {
        this.isCrossLoan = isCrossLoan;
    }

    public Boolean getIsIdChecked() {
        return isIdChecked;
    }

    public void setIsIdChecked(Boolean isIdChecked) {
        this.isIdChecked = isIdChecked;
    }

    public List<Contact> getContacts() {
        return contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getTokenId() {
        return tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public String getBlackBox() {
        return blackBox;
    }

    public void setBlackBox(String blackBox) {
        this.blackBox = blackBox;
    }
}
