/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.request.postloan;

import cn.fraudmetrix.cloudservice.annotation.method.GET;
import cn.fraudmetrix.cloudservice.annotation.Path;
import cn.fraudmetrix.cloudservice.annotation.QueryParam;
import cn.fraudmetrix.cloudservice.constant.RiskType;
import cn.fraudmetrix.cloudservice.request.Request;

/**
 * RiskRequest 监控风险异动列表查询
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 16:56
 */
@Path("/postloan/risk_list")
@GET
public class RiskRequest extends Request {

    /**
     * 扫描开始时间
     */
    @QueryParam("begin_time")
    private Long   beginTime;
    /**
     * 扫描结束时间
     */
    @QueryParam("end_time")
    private Long   endTime;
    /**
     * 准入报告编号
     */
    @QueryParam("report_id")
    private String reportId;
    /**
     * 姓名
     */
    @QueryParam("name")
    private String name;
    /**
     * 身份证号码
     */
    @QueryParam("id_number")
    private String idNumber;
    /**
     * 手机号码
     */
    @QueryParam("mobile")
    private String mobile;
    /**
     * 风险类型
     */
    @QueryParam("risk_type")
    private RiskType riskType;

    public Long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Long beginTime) {
        this.beginTime = beginTime;
    }

    public Long getEndTime() {
        return endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getReportId() {
        return reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public RiskType getRiskType() {
        return riskType;
    }

    public void setRiskType(RiskType riskType) {
        this.riskType = riskType;
    }
}
