/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.request.postloan;

import cn.fraudmetrix.cloudservice.annotation.FormParam;
import cn.fraudmetrix.cloudservice.annotation.method.POST;
import cn.fraudmetrix.cloudservice.annotation.Path;
import cn.fraudmetrix.cloudservice.request.Request;

/**
 * RepairRequest 贷后信修提交
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 16:18
 */
@Path("/postloan/repair")
@POST
public class RepairRequest extends Request {

    /**
     * 贷前准入报告编号
     */
    @FormParam("apply_report_id")
    private String  reportId;
    /**
     * 逾期阶段，M1,M2,M3,M4,M5,M6,M6+
     */
    @FormParam("overdue_stage")
    private String  stage;
    /**
     * 逾期时间，格式yyyy-MM-dd
     */
    @FormParam("overdue_date")
    private String  date;
    /**
     * 逾期金额
     */
    @FormParam("overdue_amount")
    private Double  amount;
    /**
     * 逾期天数
     */
    @FormParam("overdue_day")
    private Integer day;

    public String getReportId() {
        return reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getStage() {
        return stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Integer getDay() {
        return day;
    }

    public void setDay(Integer day) {
        this.day = day;
    }
}
