/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.request.postloan;

import cn.fraudmetrix.cloudservice.annotation.FormParam;
import cn.fraudmetrix.cloudservice.annotation.method.POST;
import cn.fraudmetrix.cloudservice.annotation.Path;
import cn.fraudmetrix.cloudservice.request.Request;

/**
 * MonitorRequest 贷后监控提交
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 16:48
 */
@Path("/postloan/monitor")
@POST
public class MonitorRequest extends Request {

    /**
     * 准入报告编号
     */
    @FormParam("report_id")
    private String  reportId;
    /**
     * 放款期限
     */
    @FormParam("loan_term")
    private Integer loanTerm;
    /**
     * 放款日期
     */
    @FormParam("loan_date")
    private Long    loanDate;
    /**
     * 放款金额
     */
    @FormParam("loan_amount")
    private Double  loanAmount;

    public String getReportId() {
        return reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Integer getLoanTerm() {
        return loanTerm;
    }

    public void setLoanTerm(Integer loanTerm) {
        this.loanTerm = loanTerm;
    }

    public Long getLoanDate() {
        return loanDate;
    }

    public void setLoanDate(Long loanDate) {
        this.loanDate = loanDate;
    }

    public Double getLoanAmount() {
        return loanAmount;
    }

    public void setLoanAmount(Double loanAmount) {
        this.loanAmount = loanAmount;
    }
}
