/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.object.response;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.Map;

/**
 * MonitorRisk 监控异动风险
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 17:13
 */
public class MonitorRisk {

    /**
     * 扫描时间
     */
    @JSONField(name = "scan_date")
    private Long                scanDate;
    /**
     * 报告编号
     */
    @JSONField(name = "report_id")
    private String              reportId;
    /**
     * 放款时间
     */
    @JSONField(name = "loan_date")
    private Long                loanDate;
    /**
     * 放款期限
     */
    @JSONField(name = "loan_term")
    private Integer             loanTerm;
    /**
     * 姓名
     */
    @JSONField(name = "name")
    private String              name;
    /**
     * 身份证号码
     */
    @JSONField(name = "id_number")
    private String              idNumber;
    /**
     * 手机号码
     */
    @JSONField(name = "mobile")
    private String              mobile;
    /**
     * 座机号码
     */
    @JSONField(name = "phone")
    private String              phone;
    /**
     * QQ号码
     */
    @JSONField(name = "qq")
    private String              qq;
    /**
     * 邮箱
     */
    @JSONField(name = "email")
    private String              email;
    /**
     * 银行卡号
     */
    @JSONField(name = "card_number")
    private String              cardNumber;
    /**
     * 联系人1手机号码
     */
    @JSONField(name = "contact1_mobile")
    private String              contact1Mobile;
    /**
     * 联系人2手机号码
     */
    @JSONField(name = "contact2_mobile")
    private String              contact2Mobile;
    /**
     * 联系人3手机号码
     */
    @JSONField(name = "contact3_mobile")
    private String              contact3Mobile;
    /**
     * 法院执行
     */
    @JSONField(name = "court_execution")
    private Map<String, String> courtExecution;
    /**
     * 法院失信
     */
    @JSONField(name = "court_discredit")
    private Map<String, String> courtDiscredit;
    /**
     * 网贷黑名单
     */
    @JSONField(name = "p2p_discredit")
    private Map<String, String> p2pDiscredit;
    /**
     * 助学贷款逾期
     */
    @JSONField(name = "student_loan")
    private Map<String, String> studentLoan;
    /**
     * 多平台借贷
     */
    @JSONField(name = "cross_partner")
    private Map<String, String> crossPartner;

    public Long getScanDate() {
        return scanDate;
    }

    public void setScanDate(Long scanDate) {
        this.scanDate = scanDate;
    }

    public String getReportId() {
        return reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Long getLoanDate() {
        return loanDate;
    }

    public void setLoanDate(Long loanDate) {
        this.loanDate = loanDate;
    }

    public Integer getLoanTerm() {
        return loanTerm;
    }

    public void setLoanTerm(Integer loanTerm) {
        this.loanTerm = loanTerm;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getQq() {
        return qq;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getContact1Mobile() {
        return contact1Mobile;
    }

    public void setContact1Mobile(String contact1Mobile) {
        this.contact1Mobile = contact1Mobile;
    }

    public String getContact2Mobile() {
        return contact2Mobile;
    }

    public void setContact2Mobile(String contact2Mobile) {
        this.contact2Mobile = contact2Mobile;
    }

    public String getContact3Mobile() {
        return contact3Mobile;
    }

    public void setContact3Mobile(String contact3Mobile) {
        this.contact3Mobile = contact3Mobile;
    }

    public Map<String, String> getCourtExecution() {
        return courtExecution;
    }

    public void setCourtExecution(Map<String, String> courtExecution) {
        this.courtExecution = courtExecution;
    }

    public Map<String, String> getCourtDiscredit() {
        return courtDiscredit;
    }

    public void setCourtDiscredit(Map<String, String> courtDiscredit) {
        this.courtDiscredit = courtDiscredit;
    }

    public Map<String, String> getP2pDiscredit() {
        return p2pDiscredit;
    }

    public void setP2pDiscredit(Map<String, String> p2pDiscredit) {
        this.p2pDiscredit = p2pDiscredit;
    }

    public Map<String, String> getStudentLoan() {
        return studentLoan;
    }

    public void setStudentLoan(Map<String, String> studentLoan) {
        this.studentLoan = studentLoan;
    }

    public Map<String, String> getCrossPartner() {
        return crossPartner;
    }

    public void setCrossPartner(Map<String, String> crossPartner) {
        this.crossPartner = crossPartner;
    }
}
