/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.object.response;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;

/**
 * ItemDetail 检查详情
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 10:56
 */
public class ItemDetail {

    /**
     * 网贷黑名单 - 失信次数
     */
    @JSONField(name = "discredit_times")
    private Integer       discredit;
    /**
     * 网贷黑名单 - 逾期详情
     */
    @JSONField(name = "overdue_details")
    private List<Overdue> overdue;
    /**
     * 多头借贷
     */
    @JSONField(name = "platform_count")
    private Integer       platform;
    /**
     * 身份证归属地位于高风险区域
     */
    @JSONField(name = "high_risk_areas")
    private List<String>  highRiskAreas;
    /**
     * 单位名称疑似中介关键词
     */
    @JSONField(name = "hit_list_datas")
    private List<String>  hitListDatas;

    public Integer getDiscredit() {
        return discredit;
    }

    public void setDiscredit(Integer discredit) {
        this.discredit = discredit;
    }

    public List<Overdue> getOverdue() {
        return overdue;
    }

    public void setOverdue(List<Overdue> overdue) {
        this.overdue = overdue;
    }

    public Integer getPlatform() {
        return platform;
    }

    public void setPlatform(Integer platform) {
        this.platform = platform;
    }

    public List<String> getHighRiskAreas() {
        return highRiskAreas;
    }

    public void setHighRiskAreas(List<String> highRiskAreas) {
        this.highRiskAreas = highRiskAreas;
    }

    public List<String> getHitListDatas() {
        return hitListDatas;
    }

    public void setHitListDatas(List<String> hitListDatas) {
        this.hitListDatas = hitListDatas;
    }
}
