/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.constant;

/**
 * RiskType 风险类型
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 17:06
 */
public enum RiskType {

    /**
     * 网贷黑名单
     */
    p2p_discredit("网贷黑名单"),
    /**
     * 多平台借贷
     */
    cross_partner("多平台借贷"),
    /**
     * 法院执行
     */
    court_execution("法院执行"),
    /**
     * 法院失信
     */
    court_discredit("法院失信"),
    /**
     * 助学贷款
     */
    student_loan("助学贷款"),;

    private String displayName;

    RiskType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return displayName;
    }
}
