/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.constant;

/**
 * Industry 行业
 *
 * @author jianhao.dai@fraudmetrix.cn 15/9/24 10:09
 */
public enum Industry {
    /**
     * 金融/银行/保险
     */
    FINANCE("金融/银行/保险"),
    /**
     * 计算机/互联网/通信/电子
     */
    COMPUTER("计算机/互联网/通信/电子"),
    /**
     * 贸易/消费/制造
     */
    TRADE_CONSUMPTION_MANUFACTURE("贸易/消费/制造"),
    /**
     * 医疗/制药
     */
    MEDICAL_PHARMACY("医疗/制药"),
    /**
     * 广告/媒体
     */
    ADS_MEDIA("广告/媒体"),
    /**
     * 房地产/建筑
     */
    BUILDING_REALESTATE("房地产/建筑"),
    /**
     * 教育/培训/咨询
     */
    EDUCATION_TRAIN_CONSULT("教育/培训/咨询"),
    /**
     * 服务业(餐饮、酒店、休闲、美容、体育等)
     */
    SERVICE("服务业(餐饮、酒店、休闲、美容、体育等)"),
    /**
     * 能源/材料
     */
    ENERGY_MATERIAL("能源/材料"),
    /**
     * 政府/NGO
     */
    GOV_NGO("政府/NGO");

    private String displayName;

    public String getDisplayName() {
        return displayName;
    }

    Industry(String displayName){
        this.displayName = displayName;
    }
}
