/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice.constant;

/**
 * 云服务系统环境枚举
 *
 * @author ming.ma@fruadmetrix.cn
 */
public enum Environment {

    /**
     * 风险决策系统sandbox环境
     */
    SANDBOX("https://credittest.api.tongdun.cn"),
    /**
     * 风险决策系统staging环境
     */
    STAGING("https://creditstg.api.fraudmetrix.cn"),
    /**
     * 风险决策系统product环境
     */
    PRODUCT("https://credit.api.tongdun.cn"),
    /**
     * 自定义环境
     */
    CUSTOM(null);


    /**
     * 接口地址
     */
    private String apiUrl;

    Environment(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    /**
     * 设置接口地址
     * @param apiUrl 接口地址
     */
    public Environment withApiUrl(String apiUrl) {
        if(null == this.apiUrl){
            this.apiUrl = apiUrl;
            return this;
        }
        else
            throw new UnsupportedOperationException("You can only set apiUrl for CUSTOM mode.");
    }

    /**
     * 获取对应环境的接口地址
     * @return 接口地址
     */
    public String getApiUrl() {
        if(null == apiUrl) {
            throw new IllegalStateException("You have to set apiUrl for CUSTOM mode first!");
        }
        return apiUrl;
    }
}
