/*
 * Copyright 2015 FraudMetrix.cn All right reserved. This software is the
 * confidential and proprietary information of FraudMetrix.cn ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with FraudMetrix.cn.
 */
package cn.fraudmetrix.cloudservice;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author kui.yuan@fraudmetrix.cn
 */
public class Version {

    private static final String POM_PATH = "/META-INF/maven.cn.fraudmetrix.cloudservice-client/pom.xml";
    private static String       version  = "unknown";
    static {
        InputStream inputStream = null;
        try {
            inputStream = CloudServiceClient.class.getResourceAsStream(POM_PATH);

            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(inputStream);
            Element rootElement = document.getRootElement();
            for (Object e : rootElement.getChildren()) {
                Element element = (Element) e;
                if ("version".equals(element.getName())) {
                    version = element.getValue();
                    break;
                }
            }
        } catch (JDOMException | IOException e) {
            // default: version = unknown
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {

                }
            }
        }
    }

    public static String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        System.out.println("version = " + version);
    }
}
