/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.rpc.sdk.mqtt.remote;

import cn.foxtech.common.mqtt.MqttClientHandler;
import cn.foxtech.common.mqtt.MqttClientService;
import java.util.HashMap;
import java.util.Map;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteMqttService {
    @Autowired
    private MqttClientService mqttClientService;
    private Map<String, Object> mqttConfig = new HashMap<String, Object>();

    public void initialize(MqttClientHandler clientHandler) {
        this.mqttClientService.getMqttClientListener().setClientHandler(clientHandler);
        this.mqttClientService.Initialize(this.mqttConfig);
    }

    public MqttClient getClient() {
        return this.mqttClientService.getMqttClient();
    }

    public void waitConnected(long timeout) {
        long startTime = System.currentTimeMillis();
        while (!this.mqttClientService.getMqttClient().isConnected()) {
            if (timeout < System.currentTimeMillis() - startTime) {
                return;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                e.getMessage();
                continue;
            }
            break;
        }
        return;
    }

    public void setMqttConfig(Map<String, Object> mqttConfig) {
        this.mqttConfig = mqttConfig;
    }
}

