/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.rpc.sdk.mqtt.remote;

import cn.foxtech.common.domain.vo.RestfulLikeRespondVO;
import cn.foxtech.common.mqtt.MqttClientHandler;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.syncobject.SyncFlagObjectMap;
import java.nio.ByteBuffer;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import org.tio.core.ChannelContext;
import org.tio.utils.buffer.ByteBufferUtil;

public class RemoteMqttHandler
extends MqttClientHandler {
    private String topic = "/fox/manager/e2c/forward/#";

    public void onMessage(ChannelContext context, String topic, MqttPublishMessage message, ByteBuffer payload) {
        String json = ByteBufferUtil.toString((ByteBuffer)payload);
        this.notifyRespond(topic, json);
    }

    private void notifyRespond(String topic, String json) {
        try {
            RestfulLikeRespondVO respondVO = (RestfulLikeRespondVO)JsonUtils.buildObject((String)json, RestfulLikeRespondVO.class);
            if (respondVO.getUuid() == null || respondVO.getUuid().isEmpty()) {
                return;
            }
            respondVO.setTopic(topic);
            SyncFlagObjectMap.inst().notifyDynamic(respondVO.getUuid(), (Object)respondVO);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }
}

