/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.rpc.sdk.mqtt;

import cn.foxtech.channel.domain.ChannelRequestVO;
import cn.foxtech.channel.domain.ChannelRespondVO;
import cn.foxtech.common.domain.vo.RestfulLikeRequestVO;
import cn.foxtech.common.domain.vo.RestfulLikeRespondVO;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.core.exception.ServiceException;
import cn.foxtech.device.domain.vo.OperateRequestVO;
import cn.foxtech.device.domain.vo.TaskRequestVO;
import cn.foxtech.device.domain.vo.TaskRespondVO;
import cn.foxtech.rpc.sdk.mqtt.RpcSdkMqttClient;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RpcSdkMqttHelper {
    @Autowired
    private RpcSdkMqttClient mqttClient;

    public TaskRequestVO buildTaskRequestVO(Map<String, Object> deviceEntity, String operateMode, String operateName, Map<String, Object> taskParam) {
        Map deviceParam = (Map)deviceEntity.get("deviceParam");
        return this.buildTaskRequestVO(deviceEntity, deviceParam, operateMode, operateName, taskParam, 2000, false);
    }

    public TaskRequestVO buildTaskRequestVO(Map<String, Object> deviceEntity, Map<String, Object> deviceParam, String operateMode, String operateName, Map<String, Object> taskParam) {
        return this.buildTaskRequestVO(deviceEntity, deviceParam, operateMode, operateName, taskParam, 2000);
    }

    public TaskRequestVO buildTaskRequestVO(Map<String, Object> deviceEntity, Map<String, Object> deviceParam, String operateMode, String operateName, Map<String, Object> taskParam, Integer timeout) {
        return this.buildTaskRequestVO(deviceEntity, deviceParam, operateMode, operateName, taskParam, timeout, false);
    }

    public TaskRequestVO buildTaskRequestVO(Map<String, Object> deviceEntity, Map<String, Object> deviceParam, String operateMode, String operateName, Map<String, Object> taskParam, Integer timeout, Boolean record) {
        String manufacturer = (String)deviceEntity.get("manufacturer");
        String deviceType = (String)deviceEntity.get("deviceType");
        String deviceName = (String)deviceEntity.get("deviceName");
        if (MethodUtils.hasEmpty((Object[])new Object[]{manufacturer, deviceType, deviceName})) {
            throw new ServiceException("\u8f93\u5165\u53c2\u6570\u53c2\u6570\uff1adeviceEntity\u4e2d\uff0cmanufacturer, deviceType, deviceName\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5b83\u662f\u7531DeviceEntity\u8f6c\u6362\u7684Map\uff0c\u4e0d\u5e94\u8be5\u4e3a\u7a7a!");
        }
        if (MethodUtils.hasNull((Object[])new Object[]{deviceParam})) {
            throw new ServiceException("\u8f93\u5165\u53c2\u6570\u53c2\u6570\uff1adeviceParam\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5b83\u662f\u7531DeviceEntity\u8f6c\u6362\u7684Map\uff0c\u4e0d\u5e94\u8be5\u4e3a\u7a7a!");
        }
        if (MethodUtils.hasEmpty((Object[])new Object[]{operateMode, operateName, timeout})) {
            throw new ServiceException("\u8f93\u5165\u53c2\u6570\uff1aoperateMode, operateName, timeout\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (MethodUtils.hasNull((Object[])new Object[]{taskParam})) {
            throw new ServiceException("\u8f93\u5165\u53c2\u6570\u53c2\u6570\uff1ataskParam\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (record == null) {
            record = true;
        }
        TaskRequestVO taskRequestVO = new TaskRequestVO();
        taskRequestVO.setUuid(UUID.randomUUID().toString().replace("-", ""));
        Integer totalTimeout = 0;
        OperateRequestVO operateRequestVO = new OperateRequestVO();
        operateRequestVO.setManufacturer(manufacturer);
        operateRequestVO.setDeviceType(deviceType);
        operateRequestVO.setDeviceName(deviceName);
        operateRequestVO.setUuid(UUID.randomUUID().toString().replace("-", ""));
        operateRequestVO.setRecord(record);
        operateRequestVO.setOperateMode(operateMode);
        operateRequestVO.setOperateName(operateName);
        operateRequestVO.setTimeout(timeout);
        if (taskParam != null) {
            operateRequestVO.getParam().putAll(taskParam);
        }
        if (deviceParam != null) {
            operateRequestVO.getParam().putAll(deviceParam);
        }
        taskRequestVO.getRequestVOS().add(operateRequestVO);
        totalTimeout = totalTimeout + operateRequestVO.getTimeout();
        taskRequestVO.setTimeout(totalTimeout);
        return taskRequestVO;
    }

    public TaskRespondVO executeDeviceOperateTask(String edgeId, TaskRequestVO taskRequestVO) {
        try {
            RestfulLikeRequestVO restfulLikeRequestVO = new RestfulLikeRequestVO();
            restfulLikeRequestVO.setTopic("/fox/manager/c2e/" + edgeId + "/forward");
            restfulLikeRequestVO.setUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            Map body = (Map)JsonUtils.buildObject((Object)taskRequestVO, Map.class);
            restfulLikeRequestVO.setResource("/proxy-redis-topic/proxy/redis/topic/device");
            restfulLikeRequestVO.setMethod("post");
            restfulLikeRequestVO.setBody((Object)body);
            this.mqttClient.sendRequest(restfulLikeRequestVO);
            RestfulLikeRespondVO restfulLikeRespondVO = this.mqttClient.waitRespond(restfulLikeRequestVO.getUuid(), taskRequestVO.getTimeout() + 10000);
            if (restfulLikeRespondVO == null) {
                throw new ServiceException("Fox-Edge\u8fd4\u56derespondVO\u4e3a\u7a7a!");
            }
            if (restfulLikeRespondVO.getBody() == null) {
                throw new ServiceException("Fox-Edge\u8fd4\u56deBody\u4e3a\u7a7a!");
            }
            return TaskRespondVO.buildRespondVO((Map)((Map)restfulLikeRespondVO.getBody()));
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }

    public ChannelRespondVO executeChannelOperateTask(String edgeId, ChannelRequestVO channelRequestVO) {
        try {
            RestfulLikeRequestVO requestVO = new RestfulLikeRequestVO();
            requestVO.setTopic("/fox/manager/c2e/" + edgeId + "/forward");
            requestVO.setUuid(UUID.randomUUID().toString().replaceAll("-", ""));
            Map body = (Map)JsonUtils.buildObject((Object)channelRequestVO, Map.class);
            requestVO.setResource("/proxy-redis-topic/proxy/redis/topic/channel");
            requestVO.setMethod("post");
            requestVO.setBody((Object)body);
            this.mqttClient.sendRequest(requestVO);
            RestfulLikeRespondVO respondVO = this.mqttClient.waitRespond(requestVO.getUuid(), channelRequestVO.getTimeout() + 10000);
            if (respondVO == null) {
                throw new ServiceException("Fox-Edge\u8fd4\u56derespondVO\u4e3a\u7a7a!");
            }
            if (respondVO.getBody() == null) {
                throw new ServiceException("Fox-Edge\u8fd4\u56deBody\u4e3a\u7a7a!");
            }
            return ChannelRespondVO.buildVO((Map)((Map)respondVO.getBody()));
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }
}

