/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.rpc.sdk.mqtt;

import cn.foxtech.common.domain.vo.RestfulLikeRequestVO;
import cn.foxtech.common.domain.vo.RestfulLikeRespondVO;
import cn.foxtech.common.mqtt.MqttClientHandler;
import cn.foxtech.common.utils.file.FileTextUtils;
import cn.foxtech.common.utils.json.JsonUtils;
import cn.foxtech.common.utils.method.MethodUtils;
import cn.foxtech.common.utils.syncobject.SyncFlagObjectMap;
import cn.foxtech.core.exception.ServiceException;
import cn.foxtech.rpc.sdk.mqtt.remote.RemoteMqttService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class RpcSdkMqttClient {
    @Autowired
    private RemoteMqttService remoteMqtt;

    public void initialize(MqttClientHandler clientHandler) {
        this.remoteMqtt.initialize(clientHandler);
    }

    public void waitConnected(long timeout) {
        this.remoteMqtt.waitConnected(timeout);
    }

    public void setMqttConfig(Map<String, Object> mqttConfig) {
        this.remoteMqtt.setMqttConfig(mqttConfig);
    }

    public Map<String, Object> buildMqttDefaultConfig() {
        try {
            ClassPathResource classPathResource = new ClassPathResource("mqttDefaultConfig.json");
            InputStream inputStream = classPathResource.getInputStream();
            String json = FileTextUtils.readTextFile((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Map defaultConfig = (Map)JsonUtils.buildObject((String)json, Map.class);
            String clientId = (String)defaultConfig.get("clientId");
            if (clientId == null || clientId.isEmpty()) {
                defaultConfig.put("clientId", UUID.randomUUID().toString());
            }
            return defaultConfig;
        }
        catch (Exception e) {
            throw new ServiceException("\u751f\u6210\u7f3a\u7701\u914d\u7f6e\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void sendRequest(RestfulLikeRequestVO requestVO) {
        try {
            if (MethodUtils.hasEmpty((Object[])new Object[]{requestVO.getTopic(), requestVO.getUuid(), requestVO.getResource(), requestVO.getMethod()})) {
                throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1atopic, uuid, resource, method");
            }
            String json = JsonUtils.buildJson((Object)requestVO);
            byte[] send = json.getBytes(StandardCharsets.UTF_8);
            this.remoteMqtt.getClient().publish(requestVO.getTopic(), send);
        }
        catch (Exception e) {
            throw new ServiceException("\u53d1\u9001MQTT\u62a5\u6587\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public RestfulLikeRespondVO waitRespond(String uuid, long timeout) {
        try {
            RestfulLikeRespondVO respondVO = (RestfulLikeRespondVO)SyncFlagObjectMap.inst().waitDynamic(uuid, timeout);
            return respondVO;
        }
        catch (Exception e) {
            return null;
        }
    }

    public RemoteMqttService getRemoteMqtt() {
        return this.remoteMqtt;
    }
}

