/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.zxdu58;

import cn.foxtech.device.protocol.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.core.utils.BitsUtils;
import cn.foxtech.device.protocol.core.utils.HexUtils;
import cn.foxtech.device.protocol.telecom.core.TelecomProtocol;
import cn.foxtech.device.protocol.zxdu58.ZXDU58ProtocolFrame;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="ZXDU58", manufacturer="\u4e2d\u5174\u901a\u8baf")
public class ZXDU58ProtocolGetRECData
extends ZXDU58ProtocolFrame {
    @FoxEdgeOperate(name="\u83b7\u53d6\u6574\u6d41\u7cfb\u7edf\u6a21\u62df\u91cf\u91cf\u5316\u6570\u636e", polling=true, type="encoder", timeout=2000)
    public static String packCmdGetRECData(Map<String, Object> param) {
        ZXDU58ProtocolGetRECData.pretreatParam(param);
        byte[] arrData = new byte[]{};
        param.put("CID1", 65);
        param.put("CID2", 65);
        param.put("INFO", arrData);
        return HexUtils.byteArrayToHexString((byte[])TelecomProtocol.packCmd4Map(param));
    }

    @FoxEdgeOperate(name="\u83b7\u53d6\u6574\u6d41\u7cfb\u7edf\u6a21\u62df\u91cf\u91cf\u5316\u6570\u636e", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unPackCmdGetRECData(String hexString, Map<String, Object> param) {
        byte[] arrCmd = HexUtils.hexStringToByteArray((String)hexString);
        Map<String, Object> value = ZXDU58ProtocolFrame.unPackCmd4Map(arrCmd);
        if (value == null) {
            return null;
        }
        if (!value.get("CID1").equals((byte)65)) {
            return null;
        }
        if (!value.get("CID2").equals((byte)0)) {
            return null;
        }
        byte[] arrData = (byte[])value.get("INFO");
        if (arrData.length < 6) {
            return null;
        }
        int iModuleNo = arrData[5];
        int nSize = 6 + iModuleNo * 5;
        if (arrData.length != nSize) {
            return null;
        }
        int index = 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("\u6574\u6d41\u6a21\u5757\u8f93\u51fa\u7535\u538b", Float.valueOf(BitsUtils.bitsToFloat((byte)arrData[index++], (byte)arrData[index++], (byte)arrData[index++], (byte)arrData[index++])));
        result.put("\u6574\u6d41\u6a21\u5757\u6570\u91cf", arrData[index++]);
        for (int i = 0; i < iModuleNo; ++i) {
            result.put(String.format("\u6a21\u5757%02d\u8f93\u51fa\u7535\u6d41", i + 1), Float.valueOf(BitsUtils.bitsToFloat((byte)arrData[index++], (byte)arrData[index++], (byte)arrData[index++], (byte)arrData[index++])));
            ++index;
        }
        return result;
    }
}

