/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.zktl.air5in1.encoder;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.utils.AsciiUtils;
import cn.foxtech.device.protocol.v1.zktl.air5in1.entity.ZktlConfigEntity;
import cn.foxtech.device.protocol.v1.zktl.air5in1.entity.ZktlDataEntity;
import cn.foxtech.device.protocol.v1.zktl.air5in1.entity.ZktlLoRaDataEntity;
import cn.foxtech.device.protocol.v1.zktl.air5in1.entity.ZktlLoRaWanDataEntity;
import cn.foxtech.device.protocol.v1.zktl.air5in1.entity.ZktlNbDataEntity;
import cn.foxtech.device.protocol.v1.zktl.air5in1.entity.ZktlPduEntity;

public class Encoder {
    public static String encodePdu(ZktlConfigEntity entity) {
        return "setdev=" + entity.getCommunType() + "," + entity.getDeviceType() + "," + entity.getValue() + "AA";
    }

    public static ZktlPduEntity decodePduEntity(String pdu) {
        if (pdu.length() < 8) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        if (pdu.charAt(0) != '2' || pdu.charAt(1) != '4' || pdu.charAt(2) != '2' || pdu.charAt(3) != '4') {
            throw new ProtocolException("\u62a5\u5934\u975e\u6cd5");
        }
        if (pdu.charAt(pdu.length() - 1) != 'A' || pdu.charAt(pdu.length() - 2) != 'A') {
            throw new ProtocolException("\u62a5\u5c3e\u975e\u6cd5");
        }
        byte communType = AsciiUtils.asciiToHex((byte)((byte)pdu.charAt(4)));
        byte deviceType = AsciiUtils.asciiToHex((byte)((byte)pdu.charAt(5)));
        int len = Integer.parseInt(pdu.substring(6, 8), 16);
        if (pdu.length() != len + 8) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        ZktlPduEntity entity = new ZktlPduEntity();
        entity.setCommunType(communType);
        entity.setDeviceType(deviceType);
        entity.setData(pdu.substring(8, pdu.length() - 2));
        return entity;
    }

    public static ZktlPduEntity decodePduEntity(byte[] pdu) {
        String str = new String(pdu);
        return Encoder.decodePduEntity(str);
    }

    public static ZktlNbDataEntity decodeNbDataEntity(String data) {
        if (data.length() < 54) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e!");
        }
        int pos = 0;
        String IMEI = Encoder.substring(data, pos, 15);
        String ICCID = Encoder.substring(data, pos += 15, 20);
        String tamper = Encoder.substring(data, pos += 20, 1);
        String externalTrigger = Encoder.substring(data, ++pos, 1);
        String externalSwitch2 = Encoder.substring(data, ++pos, 1);
        String externalSwitch1 = Encoder.substring(data, ++pos, 1);
        String packType = Encoder.substring(data, ++pos, 1);
        String batteryVoltage = Encoder.substring(data, ++pos, 4);
        String collectData = Encoder.substring(data, pos += 4, 4);
        String signal = Encoder.substring(data, pos += 4, 2);
        String packSn = Encoder.substring(data, pos += 2, 2);
        String reserve = Encoder.substring(data, pos += 2, 2);
        pos += 2;
        ZktlNbDataEntity entity = new ZktlNbDataEntity();
        entity.setImei(IMEI);
        entity.setIccid(ICCID);
        entity.setCollectData((double)Encoder.hex2int(collectData) / 1000.0);
        entity.setBatteryVoltage((double)Encoder.hex2int(batteryVoltage) / 1000.0);
        entity.setExternalSwitch1(Encoder.hex2int(externalSwitch1));
        entity.setExternalSwitch2(Encoder.hex2int(externalSwitch2));
        entity.setExternalTrigger(Encoder.hex2int(externalTrigger));
        entity.setPackType(Encoder.hex2int(packType));
        entity.setTamper(Encoder.hex2int(tamper));
        entity.setSignal(Encoder.hex2int(signal) - 110);
        entity.setPackSn(Encoder.hex2int(packSn));
        entity.setReserve(Encoder.hex2int(reserve));
        return entity;
    }

    public static ZktlLoRaDataEntity decodeLoRaDataEntity(String data) {
        if (data.length() < 36) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e!");
        }
        int pos = 0;
        String Addr = Encoder.substring(data, pos, 8);
        String tamper = Encoder.substring(data, pos += 8, 1);
        String externalTrigger = Encoder.substring(data, ++pos, 1);
        String externalSwitch2 = Encoder.substring(data, ++pos, 1);
        String externalSwitch1 = Encoder.substring(data, ++pos, 1);
        String packType = Encoder.substring(data, ++pos, 1);
        String batteryVoltage = Encoder.substring(data, ++pos, 4);
        String collectData = Encoder.substring(data, pos += 4, 4);
        String signal = Encoder.substring(data, pos += 4, 2);
        String packSn = Encoder.substring(data, pos += 2, 2);
        String reserve = Encoder.substring(data, pos += 2, 2);
        pos += 2;
        ZktlLoRaDataEntity entity = new ZktlLoRaDataEntity();
        entity.setAddr(Addr);
        entity.setCollectData((double)Encoder.hex2int(collectData) / 1000.0);
        entity.setBatteryVoltage((double)Encoder.hex2int(batteryVoltage) / 1000.0);
        entity.setExternalSwitch1(Encoder.hex2int(externalSwitch1));
        entity.setExternalSwitch2(Encoder.hex2int(externalSwitch2));
        entity.setExternalTrigger(Encoder.hex2int(externalTrigger));
        entity.setPackType(Encoder.hex2int(packType));
        entity.setTamper(Encoder.hex2int(tamper));
        entity.setSignal(Encoder.hex2int(signal) - 110);
        entity.setPackSn(Encoder.hex2int(packSn));
        entity.setReserve(Encoder.hex2int(reserve));
        return entity;
    }

    public static ZktlLoRaWanDataEntity decodeLoRaWanDataEntity(String data) {
        if (data.length() < 28) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e!");
        }
        int pos = 0;
        String tamper = Encoder.substring(data, pos, 1);
        String externalTrigger = Encoder.substring(data, ++pos, 1);
        String externalSwitch2 = Encoder.substring(data, ++pos, 1);
        String externalSwitch1 = Encoder.substring(data, ++pos, 1);
        String packType = Encoder.substring(data, ++pos, 1);
        String batteryVoltage = Encoder.substring(data, ++pos, 4);
        String collectData = Encoder.substring(data, pos += 4, 4);
        String signal = Encoder.substring(data, pos += 4, 2);
        String packSn = Encoder.substring(data, pos += 2, 2);
        String reserve = Encoder.substring(data, pos += 2, 2);
        pos += 2;
        ZktlLoRaWanDataEntity entity = new ZktlLoRaWanDataEntity();
        entity.setCollectData((double)Encoder.hex2int(collectData) / 1000.0);
        entity.setBatteryVoltage((double)Encoder.hex2int(batteryVoltage) / 1000.0);
        entity.setExternalSwitch1(Encoder.hex2int(externalSwitch1));
        entity.setExternalSwitch2(Encoder.hex2int(externalSwitch2));
        entity.setExternalTrigger(Encoder.hex2int(externalTrigger));
        entity.setPackType(Encoder.hex2int(packType));
        entity.setTamper(Encoder.hex2int(tamper));
        entity.setSignal(Encoder.hex2int(signal) - 110);
        entity.setPackSn(Encoder.hex2int(packSn));
        entity.setReserve(Encoder.hex2int(reserve));
        return entity;
    }

    public static ZktlDataEntity decodeDataEntity(byte[] pdu) {
        String str = new String(pdu);
        return Encoder.decodeDataEntity(str);
    }

    public static ZktlDataEntity decodeDataEntity(String pdu) {
        ZktlPduEntity pduEntity = Encoder.decodePduEntity(pdu);
        ZktlDataEntity dataEntity = Encoder.decodeDataEntity(pduEntity.getCommunType(), pduEntity.getData());
        dataEntity.setCommunType(pduEntity.getCommunType());
        dataEntity.setDeviceType(pduEntity.getDeviceType());
        return dataEntity;
    }

    public static ZktlDataEntity decodeDataEntity(int communType, String data) {
        if (communType == 0) {
            return Encoder.decodeNbDataEntity(data);
        }
        if (communType == 1) {
            return Encoder.decodeLoRaDataEntity(data);
        }
        if (communType == 2) {
            return Encoder.decodeLoRaWanDataEntity(data);
        }
        throw new ProtocolException("\u672a\u5b9a\u4e49\u7684\u901a\u4fe1\u7c7b\u578b:" + communType);
    }

    private static String substring(String data, int start, int len) {
        return data.substring(start, start + len);
    }

    private static int hex2int(String value) {
        long sum = 0L;
        for (int index = 0; index < value.length(); ++index) {
            String cv = "" + value.charAt(index);
            int iv = Integer.parseInt(cv, 16);
            sum *= 16L;
            sum += (long)iv;
        }
        return (int)sum;
    }

    public static void main(String[] args) {
        ZktlPduEntity entity = Encoder.decodePduEntity("24240838867572058700527898611212450141741910058009b00b30064b60AA");
        Encoder.decodeDataEntity(entity.getCommunType(), entity.getData());
        entity = Encoder.decodePduEntity("24241828131D467F0053009000a9006400bb019a000200AA");
        Encoder.decodeDataEntity(entity.getCommunType(), entity.getData());
        entity = Encoder.decodePduEntity("242428200056008b009c006400bc0194000200AA");
        Encoder.decodeDataEntity(entity.getCommunType(), entity.getData());
        ZktlDataEntity entity1 = Encoder.decodeDataEntity("24240843867572058700527898611212450141741910058009b00b3006400b6019e110200AA");
        String key = entity1.getServiceKey();
    }
}

