/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.utils;

public class HexUtils {
    public static byte hex2byte(String hex) {
        return Integer.valueOf(hex, 16).byteValue();
    }

    public static byte[] hexStringToByteArray(String hexString) {
        String string = hexString.replaceAll(" ", "");
        byte[] byteArray = new byte[string.length() / 2];
        HexUtils.hexStringToByteArray(string, byteArray, 0);
        return byteArray;
    }

    public static void hexStringToByteArray(String hexString, byte[] byteArray, int offset) {
        int length = hexString.length() / 2;
        if (byteArray.length < length) {
            length = byteArray.length;
        }
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(pos), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(pos + 1), 16) & 0xFF);
            byteArray[offset + i] = (byte)(high << 4 | low);
            pos += 2;
        }
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        return HexUtils.byteArrayToHexString(byteArray, false);
    }

    public static String byteArrayToHexString(byte[] byteArray, boolean blankz) {
        return HexUtils.byteArrayToHexString(byteArray, 0, byteArray.length, blankz);
    }

    public static String byteArrayToHexString(byte[] byteArray, int offset, int length, boolean blankz) {
        StringBuilder hexString = new StringBuilder();
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
            if (!blankz) continue;
            hexString.append(" ");
        }
        return hexString.toString();
    }
}

