/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.utils;

public class ByteUtils {
    public static void encodeInt32(long value, byte[] data, int offset, boolean msbFirst) {
        if (msbFirst) {
            data[offset + 3] = (byte)(value >> 0 & 0xFFL);
            data[offset + 2] = (byte)(value >> 8 & 0xFFL);
            data[offset + 1] = (byte)(value >> 16 & 0xFFL);
            data[offset + 0] = (byte)(value >> 24 & 0xFFL);
        } else {
            data[offset + 0] = (byte)(value >> 0 & 0xFFL);
            data[offset + 1] = (byte)(value >> 8 & 0xFFL);
            data[offset + 2] = (byte)(value >> 16 & 0xFFL);
            data[offset + 3] = (byte)(value >> 24 & 0xFFL);
        }
    }

    public static void encodeInt16(int value, byte[] data, int offset, boolean msbFirst) {
        if (msbFirst) {
            data[offset + 0] = (byte)(value >> 8 & 0xFF);
            data[offset + 1] = (byte)(value & 0xFF);
        } else {
            data[offset + 1] = (byte)(value >> 8 & 0xFF);
            data[offset + 0] = (byte)(value & 0xFF);
        }
    }

    public static int decodeInt16(byte[] data, int offset, boolean msbFirst) {
        if (msbFirst) {
            int value = 0;
            value += (data[offset + 0] & 0xFF) * 256;
            return value += (data[offset + 1] & 0xFF) * 1;
        }
        int value = 0;
        value += (data[offset + 1] & 0xFF) * 256;
        return value += (data[offset + 0] & 0xFF) * 1;
    }

    public static int decodeInt16(byte[] data, boolean msbFirst) {
        return ByteUtils.decodeInt16(data, 0, msbFirst);
    }

    public static int decodeInt16(byte[] data) {
        return ByteUtils.decodeInt16(data, true);
    }

    public static long decodeInt32(byte[] data, int offset, boolean msbFirst) {
        if (msbFirst) {
            long value = 0L;
            value += (long)(data[offset + 0] & 0xFF) * 0x1000000L;
            value += (long)(data[offset + 1] & 0xFF) * 65536L;
            value += (long)(data[offset + 2] & 0xFF) * 256L;
            return value += (long)(data[offset + 3] & 0xFF) * 1L;
        }
        long value = 0L;
        value += (long)(data[offset + 3] & 0xFF) * 0x1000000L;
        value += (long)(data[offset + 2] & 0xFF) * 65536L;
        value += (long)(data[offset + 1] & 0xFF) * 256L;
        return value += (long)(data[offset + 0] & 0xFF) * 1L;
    }

    public static long decodeInt32(byte[] data, boolean msbFirst) {
        return ByteUtils.decodeInt32(data, 0, msbFirst);
    }

    public static long decodeInt32(byte[] data) {
        return ByteUtils.decodeInt32(data, 0, true);
    }

    public static String decodeAscii(byte[] data, int offset, int length, boolean msbFirst) {
        byte by;
        if (msbFirst) {
            byte by2;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length && (by2 = data[i + offset]) != 0; ++i) {
                sb.append((char)by2);
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length && (by = data[i + length + offset - 1]) != 0; ++i) {
            sb.append((char)by);
        }
        return sb.toString();
    }

    public static void encodeAscii(String str, byte[] data, int offset, int length, boolean msbFirst) {
        if (msbFirst) {
            for (int i = 0; i < str.length(); ++i) {
                data[i + offset] = (byte)str.charAt(i);
            }
        } else {
            for (int i = 0; i < str.length(); ++i) {
                data[i + length + offset - 1] = (byte)str.charAt(i);
            }
        }
    }
}

