/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.utils;

public class BitsUtils {
    public static int bitsToInteger(byte[] bts) {
        int bits = (bts[0] & 0xFF) + ((bts[1] & 0xFF) << 8) + ((bts[2] & 0xFF) << 16) + ((bts[3] & 0xFF) << 24);
        return bits;
    }

    public static float bitsToInteger(byte bts0, byte bts1, byte bts2, byte bts3) {
        int bits = (bts0 & 0xFF) + ((bts1 & 0xFF) << 8) + ((bts2 & 0xFF) << 16) + ((bts3 & 0xFF) << 24);
        return bits;
    }

    public static float bitsToFloat(byte[] bts) {
        if (bts.length == 4) {
            int bits = 0;
            bits += (bts[0] & 0xFF) << 0;
            bits += (bts[1] & 0xFF) << 8;
            bits += (bts[2] & 0xFF) << 16;
            return Float.intBitsToFloat(bits += (bts[3] & 0xFF) << 24);
        }
        return 0.0f;
    }

    public static float bitsToFloat(byte bts0, byte bts1, byte bts2, byte bts3) {
        int bits = 0;
        bits += (bts0 & 0xFF) << 0;
        bits += (bts1 & 0xFF) << 8;
        bits += (bts2 & 0xFF) << 16;
        return Float.intBitsToFloat(bits += (bts3 & 0xFF) << 24);
    }

    public static float bitsToFloat(int bits) {
        return Float.intBitsToFloat(bits);
    }

    public static double bitsToDouble(byte[] bts) {
        if (bts.length == 8) {
            long bits = (bts[0] & 0xFF) + ((bts[1] & 0xFF) << 8) + ((bts[2] & 0xFF) << 16) + ((bts[3] & 0xFF) << 24) + ((bts[4] & 0xFF) << 32) + ((bts[5] & 0xFF) << 40) + ((bts[6] & 0xFF) << 48) + ((bts[7] & 0xFF) << 56);
            return Double.longBitsToDouble(bits);
        }
        return 0.0;
    }

    public static double bitsToDouble(byte bts0, byte bts1, byte bts2, byte bts3, byte bts4, byte bts5, byte bts6, byte bts7) {
        long bits = (bts0 & 0xFF) + ((bts1 & 0xFF) << 8) + ((bts2 & 0xFF) << 16) + ((bts3 & 0xFF) << 24) + ((bts4 & 0xFF) << 32) + ((bts5 & 0xFF) << 40) + ((bts6 & 0xFF) << 48) + ((bts7 & 0xFF) << 56);
        return Double.longBitsToDouble(bits);
    }

    public static int getBitsValue(int value, int bitIndex) {
        return BitsUtils.getBitsValue(value, bitIndex, 1);
    }

    public static int getBitsValue(int value, int bitIndex, int bitWidth) {
        if (bitWidth < 1 || bitWidth > 16) {
            return 0;
        }
        int mask = 1;
        for (int i = 0; i < bitWidth - 1; ++i) {
            mask = (mask << 1) + 1;
        }
        return value >> bitIndex & mask;
    }
}

