/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.utils.enums;

public enum CrcType {
    CRC16IBM("CRC-16-IBM", 16, 32773, 0, 0, true),
    CRC16MAXIM("CRC-16-MAXIM", 16, 32773, 0, 65535, true),
    CRC16USB("CRC-16-USB", 16, 32773, 65535, 65535, true),
    CRC16MODBUS("CRC-16-MODBUS", 16, 32773, 65535, 0, true),
    CRC16CCITT("CRC-16-CCITT", 16, 4129, 0, 0, true),
    CRC16CCITT_FALSE("CRC-16-CCITT-FALSE", 16, 4129, 65535, 0, false),
    CRC16X25("CRC-16-X25", 16, 4129, 65535, 65535, true),
    CRC16XMODEM("CRC-16-XMODEM", 16, 4129, 0, 0, false),
    CRC16XMODEM2("CRC-16-XMODEM2", 16, 33800, 0, 0, true),
    CRC16DNP("CRC-16-DNP", 16, 15717, 0, 65535, true);

    private final String name;
    private final int length;
    private final int polynomial;
    private final int initial;
    private final int xorOut;
    private final boolean refInOut;

    private CrcType(String name, int length, int polynomial, int initial, int xorOut, boolean refInOut) {
        this.name = name;
        this.length = length;
        this.polynomial = polynomial;
        this.initial = initial;
        this.xorOut = xorOut;
        this.refInOut = refInOut;
    }

    public static CrcType getEnum(String name) {
        for (CrcType value : CrcType.values()) {
            if (!name.equals(value.name)) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public int getPolynomial() {
        return this.polynomial;
    }

    public int getInitial() {
        return this.initial;
    }

    public int getXorOut() {
        return this.xorOut;
    }

    public boolean isRefInOut() {
        return this.refInOut;
    }
}

