/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.utils;

import cn.foxtech.device.protocol.v1.utils.enums.CrcType;

public class Crc16Utils {
    public static int getCRC16RefTrue(byte[] data, int offset, int length, int polynomial, int initial, int xorOut) {
        int crc = initial;
        polynomial = Crc16Utils.invertWord(polynomial);
        for (int i = offset; i < length; ++i) {
            byte b = data[i];
            crc ^= b & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) == 1) {
                    crc = crc >>> 1 ^ polynomial;
                    continue;
                }
                crc >>>= 1;
            }
        }
        return crc & 0xFFFF ^ xorOut;
    }

    public static int getCRC16RefFalse(byte[] data, int offset, int length, int polynomial, int initial, int xorOut) {
        int crc = initial;
        for (int i = offset; i < length; ++i) {
            byte b = data[i];
            crc ^= (b & 0xFF) << 8;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 0x8000) != 0) {
                    crc = crc << 1 ^ polynomial;
                    continue;
                }
                crc <<= 1;
            }
        }
        return crc & 0xFFFF ^ xorOut;
    }

    public static int getCRC16(byte[] data, int offset, int length, int polynomial, int initial, int xorOut, boolean refInOut) {
        if (refInOut) {
            return Crc16Utils.getCRC16RefTrue(data, offset, length, polynomial, initial, xorOut);
        }
        return Crc16Utils.getCRC16RefFalse(data, offset, length, polynomial, initial, xorOut);
    }

    public static int getCRC16(byte[] data, int offset, int length, CrcType type) {
        return Crc16Utils.getCRC16(data, offset, length, type.getPolynomial(), type.getInitial(), type.getXorOut(), type.isRefInOut());
    }

    public static int invertWord(int dat) {
        int value = 0;
        for (int i = 0; i < 16; ++i) {
            value |= (dat >> i & 1) << 15 - i;
        }
        return value;
    }
}

