/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.utils;

public class BcdUtils {
    public static void str2bcd(String bcd, byte[] bcdByte, int offset, boolean bigEndian) {
        int size = bcd.length() / 2;
        int remainder = bcd.length() % 2;
        if (bigEndian) {
            for (int i = 0; i < size; ++i) {
                int high = Integer.parseInt(bcd.substring(2 * i, 2 * i + 1));
                int low = Integer.parseInt(bcd.substring(2 * i + 1, 2 * i + 2));
                bcdByte[offset + i] = (byte)(high << 4 | low);
            }
            if (remainder > 0) {
                int low = Integer.parseInt(bcd.substring(bcd.length() - 1));
                bcdByte[offset + size - 1] = (byte)(0xF0 | low);
            }
        } else {
            for (int i = size - 1; 0 <= i; --i) {
                int high = Integer.parseInt(bcd.substring(2 * i, 2 * i + 1));
                int low = Integer.parseInt(bcd.substring(2 * i + 1, 2 * i + 2));
                bcdByte[offset + i] = (byte)(high << 4 | low);
            }
            if (remainder > 0) {
                int low = Integer.parseInt(bcd.substring(bcd.length() - 1));
                bcdByte[offset + size - 1] = (byte)(0xF0 | low);
            }
        }
    }

    public static byte[] str2bcd(String bcd, boolean bigEndian) {
        int size = bcd.length() / 2;
        int remainder = bcd.length() % 2;
        byte[] bcdByte = new byte[size + remainder];
        BcdUtils.str2bcd(bcd, bcdByte, 0, bigEndian);
        return bcdByte;
    }

    public static String bcd2str(byte[] bcd) {
        if (null == bcd || bcd.length == 0) {
            return "";
        }
        return BcdUtils.bcd2str(bcd, 0, bcd.length, false);
    }

    public static String bcd2str(byte[] data, int offset, int length, boolean bigEndian) {
        StringBuilder sb = new StringBuilder();
        if (bigEndian) {
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                int low = data[i] & 0xF;
                int high = (data[i] & 0xF0) >> 4;
                if (low > 9) {
                    low = 9;
                }
                if (high > 9) {
                    high = 9;
                }
                sb.append(high);
                sb.append(low);
            }
        } else {
            int end;
            for (int i = end = offset + length - 1; offset <= i; --i) {
                int low = data[i] & 0xF;
                int high = (data[i] & 0xF0) >> 4;
                if (low > 9) {
                    low = 9;
                }
                if (high > 9) {
                    high = 9;
                }
                sb.append(high);
                sb.append(low);
            }
        }
        return sb.toString();
    }

    public static int bcd2int(byte bcd) {
        return ((bcd & 0xF0) >> 4) * 10 + (bcd & 0xF);
    }
}

