/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.telecom.core.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;

public class PduEntity {
    private int ver = 0;
    private int addr = 0;
    private int cid1 = 0;
    private int cid2 = 0;
    private byte[] data = new byte[0];

    public static byte[] encodePdu(PduEntity entity) {
        if (entity.data.length > 255) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u8d85\u8fc7255");
        }
        byte[] pdu = new byte[2 + (8 + entity.data.length) * 2];
        int index = 0;
        int value = 0;
        pdu[index++] = 126;
        value = PduEntity.hexToAscii(entity.ver);
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        value = PduEntity.hexToAscii(entity.addr);
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        value = PduEntity.hexToAscii(entity.cid1);
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        value = PduEntity.hexToAscii(entity.cid2);
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        int wLen = PduEntity.getLenCode(entity.data.length * 2);
        value = PduEntity.hexToAscii((byte)(wLen >> 8 & 0xFF));
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        value = PduEntity.hexToAscii((byte)(wLen & 0xFF));
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        for (int i = 0; i < entity.data.length; ++i) {
            value = PduEntity.hexToAscii(entity.data[i]);
            pdu[index++] = (byte)(value >> 8);
            pdu[index++] = (byte)(value & 0xFF);
        }
        int wVfy = PduEntity.getVfyCode(pdu);
        value = PduEntity.hexToAscii((byte)(wVfy >> 8 & 0xFF));
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        value = PduEntity.hexToAscii((byte)(wVfy & 0xFF));
        pdu[index++] = (byte)(value >> 8);
        pdu[index++] = (byte)(value & 0xFF);
        pdu[pdu.length - 1] = 13;
        return pdu;
    }

    public static PduEntity decodePdu(byte[] pdu) {
        return PduEntity.decodePdu(pdu, false, (byte)0);
    }

    public static PduEntity decodePdu(byte[] pdu, boolean rawData, byte defaultValue) {
        int iSize = pdu.length;
        if (iSize < 18) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u5c0f\u4e8e18");
        }
        int index = 0;
        byte chHigh = 0;
        byte chLow = 0;
        if (pdu[index++] != 126) {
            throw new ProtocolException("\u8d77\u59cb\u5b57\u7b26\u5fc5\u987b\u4f4d7E");
        }
        if (pdu[iSize - 1] != 13) {
            throw new ProtocolException("\u7ed3\u675f\u5b57\u7b26\u5fc5\u987b\u4f4d0D");
        }
        PduEntity entity = new PduEntity();
        chHigh = pdu[index++];
        chLow = pdu[index++];
        entity.ver = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
        chHigh = pdu[index++];
        chLow = pdu[index++];
        entity.addr = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
        chHigh = pdu[index++];
        chLow = pdu[index++];
        entity.cid1 = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
        chHigh = pdu[index++];
        chLow = pdu[index++];
        entity.cid2 = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
        int wLen = 0;
        chHigh = pdu[index++];
        chLow = pdu[index++];
        byte value = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
        wLen = (value & 0xFF) * 256;
        if (!PduEntity.chkLenCode(wLen += (value = PduEntity.asciiToHex(chHigh = pdu[index++], chLow = pdu[index++], defaultValue)) & 0xFF)) {
            throw new ProtocolException("\u5e27\u957f\u5ea6\u7f16\u7801\u4e0d\u6b63\u786e!");
        }
        if (pdu.length != 18 + (wLen &= 0xFFF)) {
            throw new ProtocolException("\u5e27\u957f\u5ea6\u6821\u9a8c\u4e0d\u6b63\u786e!");
        }
        if (rawData) {
            entity.data = new byte[wLen];
            for (int i = 0; i < wLen; ++i) {
                entity.data[i] = pdu[index++];
            }
        } else {
            int iDataSize = wLen / 2;
            entity.data = new byte[iDataSize];
            for (int i = 0; i < iDataSize; ++i) {
                chHigh = pdu[index++];
                chLow = pdu[index++];
                entity.data[i] = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
            }
        }
        int wVfy = 0;
        chHigh = pdu[index++];
        chLow = pdu[index++];
        value = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
        wVfy = (value & 0xFF) * 256;
        chHigh = pdu[index++];
        chLow = pdu[index++];
        value = PduEntity.asciiToHex(chHigh, chLow, defaultValue);
        int wVfyOK = PduEntity.getVfyCode(pdu);
        if (wVfyOK != (wVfy += value & 0xFF)) {
            throw new ProtocolException("\u6821\u9a8c\u548c\u4e0d\u6b63\u786e!");
        }
        return entity;
    }

    private static int getLenCode(int iLen) {
        int byLCHK = ((iLen & 0xF00) >> 8) + ((iLen & 0xF0) >> 4) + (iLen & 0xF);
        byLCHK = (byte)(byLCHK & 0xF);
        byLCHK = (byte)((byte)(~byLCHK) & 0xFF);
        byLCHK = (byte)(byLCHK & 0xF);
        int wLen = byLCHK = (byte)(byLCHK + 1);
        wLen = (wLen << 12) + iLen;
        return wLen;
    }

    private static int hexToAscii(int byAt) {
        int chAsciiH = 0;
        int chAsciiL = 0;
        switch (byAt & 0xF0) {
            case 0: {
                chAsciiH = 48;
                break;
            }
            case 16: {
                chAsciiH = 49;
                break;
            }
            case 32: {
                chAsciiH = 50;
                break;
            }
            case 48: {
                chAsciiH = 51;
                break;
            }
            case 64: {
                chAsciiH = 52;
                break;
            }
            case 80: {
                chAsciiH = 53;
                break;
            }
            case 96: {
                chAsciiH = 54;
                break;
            }
            case 112: {
                chAsciiH = 55;
                break;
            }
            case 128: {
                chAsciiH = 56;
                break;
            }
            case 144: {
                chAsciiH = 57;
                break;
            }
            case 160: {
                chAsciiH = 65;
                break;
            }
            case 176: {
                chAsciiH = 66;
                break;
            }
            case 192: {
                chAsciiH = 67;
                break;
            }
            case 208: {
                chAsciiH = 68;
                break;
            }
            case 224: {
                chAsciiH = 69;
                break;
            }
            case 240: {
                chAsciiH = 70;
                break;
            }
        }
        switch (byAt & 0xF) {
            case 0: {
                chAsciiL = 48;
                break;
            }
            case 1: {
                chAsciiL = 49;
                break;
            }
            case 2: {
                chAsciiL = 50;
                break;
            }
            case 3: {
                chAsciiL = 51;
                break;
            }
            case 4: {
                chAsciiL = 52;
                break;
            }
            case 5: {
                chAsciiL = 53;
                break;
            }
            case 6: {
                chAsciiL = 54;
                break;
            }
            case 7: {
                chAsciiL = 55;
                break;
            }
            case 8: {
                chAsciiL = 56;
                break;
            }
            case 9: {
                chAsciiL = 57;
                break;
            }
            case 10: {
                chAsciiL = 65;
                break;
            }
            case 11: {
                chAsciiL = 66;
                break;
            }
            case 12: {
                chAsciiL = 67;
                break;
            }
            case 13: {
                chAsciiL = 68;
                break;
            }
            case 14: {
                chAsciiL = 69;
                break;
            }
            case 15: {
                chAsciiL = 70;
                break;
            }
        }
        return chAsciiH << 8 | chAsciiL & 0xFF;
    }

    private static int getVfyCode(byte[] pdu) {
        int iSize = pdu.length - 6;
        if (iSize < 12) {
            return 0;
        }
        int wVfy = 0;
        for (int i = 0; i < iSize; ++i) {
            wVfy += pdu[i + 1] & 0xFF;
        }
        wVfy = ~wVfy & 0xFFFF;
        return ++wVfy;
    }

    private static byte asciiToHex(byte chAsciiH, byte chAsciiL, byte defaultValue) {
        byte byAtH = 0;
        int byAtL = 0;
        if (chAsciiH == 32) {
            byAtH = 0;
        } else if (chAsciiH >= 48 && chAsciiH <= 57) {
            byAtH = (byte)(chAsciiH - 48);
        } else if (chAsciiH >= 65 && chAsciiH <= 70) {
            byAtH = (byte)(chAsciiH - 55);
        } else {
            return defaultValue;
        }
        if (chAsciiL == 32) {
            byAtL = 0;
        } else if (chAsciiL >= 48 && chAsciiL <= 57) {
            byAtL = (byte)(chAsciiL - 48);
        } else if (chAsciiL >= 65 && chAsciiL <= 70) {
            byAtL = (byte)(chAsciiL - 55);
        } else {
            return defaultValue;
        }
        return (byte)((byAtH << 4) + byAtL);
    }

    private static boolean chkLenCode(int wLenCode) {
        int sum = 0;
        sum = wLenCode & 0xF;
        sum += wLenCode >> 4 & 0xF;
        sum += wLenCode >> 8 & 0xF;
        int wLenTemp = (((sum = ~sum + 1) & 0xF) << 12) + (wLenCode & 0xFFF);
        return wLenTemp == wLenCode;
    }

    public void setVer(int ver) {
        this.ver = ver;
    }

    public void setAddr(int addr) {
        this.addr = addr;
    }

    public void setCid1(int cid1) {
        this.cid1 = cid1;
    }

    public void setCid2(int cid2) {
        this.cid2 = cid2;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getVer() {
        return this.ver;
    }

    public int getAddr() {
        return this.addr;
    }

    public int getCid1() {
        return this.cid1;
    }

    public int getCid2() {
        return this.cid2;
    }

    public byte[] getData() {
        return this.data;
    }
}

