/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.telecom.core;

import cn.foxtech.device.protocol.core.reference.ByteRef;
import cn.foxtech.device.protocol.core.reference.BytesRef;
import cn.foxtech.device.protocol.core.reference.IntegerRef;
import cn.foxtech.device.protocol.telecom.core.TelecomEntity;
import java.util.HashMap;
import java.util.Map;

public class TelecomProtocol {
    public static final String VER = "VER";
    public static final String ADR = "ADR";
    public static final String CID1 = "CID1";
    public static final String CID2 = "CID2";
    public static final String INFO = "INFO";

    public static boolean asciiToHex(byte chAsciiH, byte chAsciiL, ByteRef byAt) {
        byte byAtH = 0;
        int byAtL = 0;
        if (chAsciiH == 32) {
            byAtH = 0;
        } else if (chAsciiH >= 48 && chAsciiH <= 57) {
            byAtH = (byte)(chAsciiH - 48);
        } else if (chAsciiH >= 65 && chAsciiH <= 70) {
            byAtH = (byte)(chAsciiH - 55);
        } else {
            return false;
        }
        if (chAsciiL == 32) {
            byAtL = 0;
        } else if (chAsciiL >= 48 && chAsciiL <= 57) {
            byAtL = (byte)(chAsciiL - 48);
        } else if (chAsciiL >= 65 && chAsciiL <= 70) {
            byAtL = (byte)(chAsciiL - 55);
        } else {
            return false;
        }
        byAt.setValue((byte)((byAtH << 4) + byAtL));
        return true;
    }

    public static int getUnPackCmdVfyCode(byte[] arrCmd) {
        int iSize = arrCmd.length - 6;
        if (iSize < 12) {
            return 0;
        }
        int index = 1;
        int wVfy = 0;
        for (int i = 0; i < iSize; ++i) {
            wVfy += arrCmd[index++] & 0xFF;
        }
        wVfy = ~wVfy & 0xFFFF;
        return ++wVfy;
    }

    private static void hexToAscii(int byAt, ByteRef chAsciiHRef, ByteRef chAsciiLRef) {
        byte chAsciiH = 0;
        byte chAsciiL = 0;
        switch (byAt & 0xF0) {
            case 0: {
                chAsciiH = 48;
                break;
            }
            case 16: {
                chAsciiH = 49;
                break;
            }
            case 32: {
                chAsciiH = 50;
                break;
            }
            case 48: {
                chAsciiH = 51;
                break;
            }
            case 64: {
                chAsciiH = 52;
                break;
            }
            case 80: {
                chAsciiH = 53;
                break;
            }
            case 96: {
                chAsciiH = 54;
                break;
            }
            case 112: {
                chAsciiH = 55;
                break;
            }
            case 128: {
                chAsciiH = 56;
                break;
            }
            case 144: {
                chAsciiH = 57;
                break;
            }
            case 160: {
                chAsciiH = 65;
                break;
            }
            case 176: {
                chAsciiH = 66;
                break;
            }
            case 192: {
                chAsciiH = 67;
                break;
            }
            case 208: {
                chAsciiH = 68;
                break;
            }
            case 224: {
                chAsciiH = 69;
                break;
            }
            case 240: {
                chAsciiH = 70;
                break;
            }
        }
        switch (byAt & 0xF) {
            case 0: {
                chAsciiL = 48;
                break;
            }
            case 1: {
                chAsciiL = 49;
                break;
            }
            case 2: {
                chAsciiL = 50;
                break;
            }
            case 3: {
                chAsciiL = 51;
                break;
            }
            case 4: {
                chAsciiL = 52;
                break;
            }
            case 5: {
                chAsciiL = 53;
                break;
            }
            case 6: {
                chAsciiL = 54;
                break;
            }
            case 7: {
                chAsciiL = 55;
                break;
            }
            case 8: {
                chAsciiL = 56;
                break;
            }
            case 9: {
                chAsciiL = 57;
                break;
            }
            case 10: {
                chAsciiL = 65;
                break;
            }
            case 11: {
                chAsciiL = 66;
                break;
            }
            case 12: {
                chAsciiL = 67;
                break;
            }
            case 13: {
                chAsciiL = 68;
                break;
            }
            case 14: {
                chAsciiL = 69;
                break;
            }
            case 15: {
                chAsciiL = 70;
                break;
            }
        }
        chAsciiHRef.setValue(chAsciiH);
        chAsciiLRef.setValue(chAsciiL);
    }

    private static int getLenCode(int iLen) {
        int byLCHK = ((iLen & 0xF00) >> 8) + ((iLen & 0xF0) >> 4) + (iLen & 0xF);
        byLCHK = (byte)(byLCHK & 0xF);
        byLCHK = (byte)((byte)(~byLCHK) & 0xFF);
        byLCHK = (byte)(byLCHK & 0xF);
        int wLen = byLCHK = (byte)(byLCHK + 1);
        wLen = (wLen << 12) + iLen;
        return wLen;
    }

    private static int getPackCmdVfyCode(byte[] arrCmd) {
        int iSize = arrCmd.length - 6;
        if (iSize < 12) {
            return 0;
        }
        int wVfy = 0;
        for (int i = 0; i < iSize; ++i) {
            wVfy += arrCmd[i + 1] & 0xFF;
        }
        wVfy = ~wVfy & 0xFFFF;
        return ++wVfy;
    }

    private static boolean chkLenCode(int wLenCode, IntegerRef wLen) {
        int sum = 0;
        sum = wLenCode & 0xF;
        sum += wLenCode >> 4 & 0xF;
        sum += wLenCode >> 8 & 0xF;
        int wLenTemp = (((sum = ~sum + 1) & 0xF) << 12) + (wLenCode & 0xFFF);
        if (wLenTemp != wLenCode) {
            return false;
        }
        wLen.setValue(wLenCode &= 0xFFF);
        return true;
    }

    public static byte[] packCmd4Entity(TelecomEntity entity) {
        int iDataSize = entity.getData().length;
        if (iDataSize > 255) {
            return null;
        }
        byte[] arrCmd = new byte[2 + (8 + iDataSize) * 2];
        int index = 0;
        ByteRef chASCIIH = new ByteRef();
        ByteRef chASCIIL = new ByteRef();
        arrCmd[index++] = 126;
        TelecomProtocol.hexToAscii(entity.getVer(), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        TelecomProtocol.hexToAscii(entity.getAddr(), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        TelecomProtocol.hexToAscii(entity.getCID1(), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        TelecomProtocol.hexToAscii(entity.getCID2(), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        int wLen = TelecomProtocol.getLenCode(iDataSize * 2);
        TelecomProtocol.hexToAscii((byte)(wLen >> 8 & 0xFF), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        TelecomProtocol.hexToAscii((byte)(wLen & 0xFF), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        for (int i = 0; i < iDataSize; ++i) {
            TelecomProtocol.hexToAscii(entity.getData()[i], chASCIIH, chASCIIL);
            arrCmd[index++] = chASCIIH.getValue();
            arrCmd[index++] = chASCIIL.getValue();
        }
        int wVfy = TelecomProtocol.getPackCmdVfyCode(arrCmd);
        TelecomProtocol.hexToAscii((byte)(wVfy >> 8 & 0xFF), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        TelecomProtocol.hexToAscii((byte)(wVfy & 0xFF), chASCIIH, chASCIIL);
        arrCmd[index++] = chASCIIH.getValue();
        arrCmd[index++] = chASCIIL.getValue();
        arrCmd[arrCmd.length - 1] = 13;
        return arrCmd;
    }

    private static boolean unPackCmd(byte[] arrCmd, ByteRef byVer, ByteRef byAddr, ByteRef byCID1, ByteRef byCID2, BytesRef arrData) {
        IntegerRef wLenRef;
        int iSize = arrCmd.length;
        if (iSize < 18) {
            return false;
        }
        int index = 0;
        byte chHigh = 0;
        byte chLow = 0;
        if (arrCmd[index++] != 126) {
            return false;
        }
        if (arrCmd[iSize - 1] != 13) {
            return false;
        }
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byVer)) {
            return false;
        }
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byAddr)) {
            return false;
        }
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byCID1)) {
            return false;
        }
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byCID2)) {
            return false;
        }
        int wLen = 0;
        ByteRef byRef = new ByteRef();
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byRef)) {
            return false;
        }
        wLen = (byRef.getValue() & 0xFF) * 256;
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byRef)) {
            return false;
        }
        if (!TelecomProtocol.chkLenCode(wLen += byRef.getValue() & 0xFF, wLenRef = new IntegerRef())) {
            return false;
        }
        if (arrCmd.length != 18 + (wLen &= 0xFFF)) {
            return false;
        }
        int iDataSize = wLen / 2;
        arrData.setValue(new byte[iDataSize]);
        for (int i = 0; i < iDataSize; ++i) {
            if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byRef)) {
                return false;
            }
            arrData.getValue()[i] = byRef.getValue();
        }
        int wVfy = 0;
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byRef)) {
            return false;
        }
        wVfy = (byRef.getValue() & 0xFF) * 256;
        if (!TelecomProtocol.asciiToHex(chHigh = arrCmd[index++], chLow = arrCmd[index++], byRef)) {
            return false;
        }
        int wVfyOK = TelecomProtocol.getUnPackCmdVfyCode(arrCmd);
        return wVfyOK == (wVfy += byRef.getValue() & 0xFF);
    }

    public static TelecomEntity unPackCmd2Entity(byte[] arrCmd) {
        ByteRef byVer = new ByteRef();
        ByteRef byAddr = new ByteRef();
        ByteRef byCID1 = new ByteRef();
        ByteRef byCID2 = new ByteRef();
        BytesRef arrData = new BytesRef();
        if (!TelecomProtocol.unPackCmd(arrCmd, byVer, byAddr, byCID1, byCID2, arrData)) {
            return null;
        }
        TelecomEntity entity = new TelecomEntity();
        entity.setVer(byVer.getValue());
        entity.setAddr(byAddr.getValue());
        entity.setCID1(byCID1.getValue());
        entity.setCID2(byCID2.getValue());
        entity.setData(arrData.getValue());
        return entity;
    }

    public static Map<String, Object> unPackCmd2Map(byte[] arrCmd) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        TelecomEntity entity = TelecomProtocol.unPackCmd2Entity(arrCmd);
        value.put(VER, entity.getVer());
        value.put(ADR, entity.getAddr());
        value.put(CID1, entity.getCID1());
        value.put(CID2, entity.getCID2());
        value.put(INFO, entity.getData());
        return value;
    }

    public static boolean checkParam(Map<String, Object> param) {
        if (!param.containsKey(VER) || !(param.get(VER) instanceof Byte) && !(param.get(VER) instanceof Integer)) {
            return false;
        }
        if (!param.containsKey(ADR) || !(param.get(ADR) instanceof Byte) && !(param.get(ADR) instanceof Integer)) {
            return false;
        }
        if (!param.containsKey(CID1) || !(param.get(CID1) instanceof Byte) && !(param.get(CID1) instanceof Integer)) {
            return false;
        }
        if (!param.containsKey(CID2) || !(param.get(CID2) instanceof Byte) && !(param.get(CID2) instanceof Integer)) {
            return false;
        }
        return param.containsKey(INFO) && param.get(INFO) instanceof byte[];
    }

    public static byte[] packCmd4Map(Map<String, Object> param) {
        if (!TelecomProtocol.checkParam(param)) {
            return null;
        }
        TelecomEntity entity = new TelecomEntity();
        entity.setVer(Byte.decode(param.get(VER).toString()));
        entity.setAddr(Byte.decode(param.get(ADR).toString()));
        entity.setCID1(Byte.decode(param.get(CID1).toString()));
        entity.setCID2(Byte.decode(param.get(CID2).toString()));
        entity.setData((byte[])param.get(INFO));
        return TelecomProtocol.packCmd4Entity(entity);
    }
}

