/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.tcl.air.adapter;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.tcl.air.adapter.entity.MsgEntity;
import cn.foxtech.device.protocol.v1.tcl.air.adapter.entity.PduEntity;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u67dc\u5f0f\u7a7a\u8c03(KPRd)", manufacturer="TCL\u79d1\u6280\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f8")
public class SetUserTurnOnOrOff {
    @FoxEdgeOperate(name="\u7528\u6237\u5f00\u5173\u7a7a\u8c03", polling=true, type="encoder", mode="status", timeout=4000)
    public static String encodePdu(Map<String, Object> param) {
        Boolean open;
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr, open = (Boolean)param.get("\u8fd0\u884c")})) {
            throw new ProtocolException("\u53c2\u6570\u7f3a\u5931\uff1adevAddr, \u8fd0\u884c");
        }
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setType(13);
        msgEntity.setSubType(open != false ? 1 : 0);
        msgEntity.setResult(0);
        PduEntity entity = new PduEntity();
        entity.setAddress(devAddr);
        entity.setData(MsgEntity.encode(msgEntity));
        byte[] pdu = PduEntity.encodePdu(entity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u7528\u6237\u5f00\u5173\u7a7a\u8c03", polling=true, type="decoder", mode="status", timeout=4000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu(pdu);
        MsgEntity msgEntity = MsgEntity.decode(entity.getData());
        if (msgEntity.getType() != 13) {
            throw new ProtocolException("\u8fd4\u56de\u7684messageType\u4e0d\u5339\u914d!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("devAddr", entity.getAddress());
        result.put("\u8fd0\u884c", msgEntity.getSubType() == 1);
        result.put("result", msgEntity.getResult());
        return result;
    }
}

