/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.tcl.air.adapter;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.tcl.air.adapter.entity.MsgEntity;
import cn.foxtech.device.protocol.v1.tcl.air.adapter.entity.PduEntity;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u67dc\u5f0f\u7a7a\u8c03(KPRd)", manufacturer="TCL\u79d1\u6280\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f8")
public class SetCurrentRunStatus {
    @FoxEdgeOperate(name="\u8bbe\u7f6e\u8fd0\u884c\u72b6\u6001", polling=true, type="encoder", mode="status", timeout=4000)
    public static String encodePdu(Map<String, Object> param) {
        Integer settingTemp;
        String mode;
        Boolean windDirect;
        Integer tempComp;
        Boolean open;
        String airVolume;
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr, airVolume = (String)param.get("\u98ce\u91cf"), open = (Boolean)param.get("\u8fd0\u884c"), tempComp = (Integer)param.get("\u6e29\u5ea6\u8865\u507f"), windDirect = (Boolean)param.get("\u98ce\u5411"), mode = (String)param.get("\u6a21\u5f0f"), settingTemp = (Integer)param.get("\u8bbe\u5b9a\u6e29\u5ea6")})) {
            throw new ProtocolException("\u53c2\u6570\u7f3a\u5931\uff1adevAddr, \u98ce\u91cf, \u8fd0\u884c, \u6e29\u5ea6\u8865\u507f, \u98ce\u5411, \u6a21\u5f0f, \u8bbe\u5b9a\u6e29\u5ea6");
        }
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setType(111);
        msgEntity.setSubType(0);
        msgEntity.setResult(0);
        msgEntity.setData(new byte[4]);
        byte[] data = msgEntity.getData();
        int value = 0;
        if (airVolume.equals("\u81ea\u52a8")) {
            value = 0;
        }
        if (airVolume.equals("\u9ad8")) {
            value = 1;
        }
        if (airVolume.equals("\u4e2d")) {
            value = 2;
        }
        if (airVolume.equals("\u4f4e")) {
            value = 3;
        }
        data[0] = (byte)(data[0] | value << 0);
        data[0] = (byte)(data[0] | (open != false ? 4 : 0));
        if (tempComp >= 2) {
            value = 2;
        }
        if (tempComp == 1) {
            value = 1;
        }
        if (tempComp == 0) {
            value = 0;
        }
        if (tempComp == -1) {
            value = 5;
        }
        if (tempComp == -2) {
            value = 6;
        }
        data[0] = (byte)(data[0] | value << 4);
        data[0] = (byte)(data[0] | (windDirect != false ? 128 : 0));
        if (mode.equals("\u5236\u70ed")) {
            value = 0;
        }
        if (mode.equals("\u81ea\u52a8")) {
            value = 1;
        }
        if (mode.equals("\u5236\u51b7")) {
            value = 2;
        }
        if (mode.equals("\u9664\u6e7f")) {
            value = 3;
        }
        if (mode.equals("\u9001\u98ce")) {
            value = 4;
        }
        data[1] = (byte)(data[1] | value << 0);
        value = settingTemp - 18;
        data[1] = (byte)(data[1] | value << 4);
        PduEntity entity = new PduEntity();
        entity.setAddress(devAddr);
        entity.setData(MsgEntity.encode(msgEntity));
        byte[] pdu = PduEntity.encodePdu(entity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u8bbe\u7f6e\u8fd0\u884c\u72b6\u6001", polling=true, type="decoder", mode="status", timeout=4000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu(pdu);
        MsgEntity msgEntity = MsgEntity.decode(entity.getData());
        if (msgEntity.getType() != 111) {
            throw new ProtocolException("\u8fd4\u56de\u7684messageType\u4e0d\u5339\u914d!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("devAddr", entity.getAddress());
        result.put("result", msgEntity.getResult());
        return result;
    }
}

