/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.tcl.air.adapter;

import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.v1.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.tcl.air.adapter.entity.MsgEntity;
import cn.foxtech.device.protocol.v1.tcl.air.adapter.entity.PduEntity;
import cn.foxtech.device.protocol.v1.utils.HexUtils;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.util.HashMap;
import java.util.Map;

@FoxEdgeDeviceType(value="\u67dc\u5f0f\u7a7a\u8c03(KPRd)", manufacturer="TCL\u79d1\u6280\u96c6\u56e2\u80a1\u4efd\u6709\u9650\u516c\u53f8")
public class GetCurrentRunStatus {
    @FoxEdgeOperate(name="\u67e5\u8be2\u8fd0\u884c\u72b6\u6001", polling=true, type="encoder", mode="status", timeout=4000)
    public static String encodePdu(Map<String, Object> param) {
        Integer devAddr = (Integer)param.get("devAddr");
        if (MethodUtils.hasEmpty((Object[])new Object[]{devAddr})) {
            throw new ProtocolException("\u53c2\u6570\u7f3a\u5931\uff1adevAddr");
        }
        MsgEntity msgEntity = new MsgEntity();
        msgEntity.setType(112);
        msgEntity.setSubType(0);
        msgEntity.setResult(0);
        PduEntity entity = new PduEntity();
        entity.setAddress(devAddr);
        entity.setData(MsgEntity.encode(msgEntity));
        byte[] pdu = PduEntity.encodePdu(entity);
        return HexUtils.byteArrayToHexString((byte[])pdu);
    }

    @FoxEdgeOperate(name="\u67e5\u8be2\u8fd0\u884c\u72b6\u6001", polling=true, type="decoder", mode="status", timeout=4000)
    public static Map<String, Object> decodePdu(String hexString, Map<String, Object> param) {
        byte[] pdu = HexUtils.hexStringToByteArray((String)hexString);
        PduEntity entity = PduEntity.decodePdu(pdu);
        MsgEntity msgEntity = MsgEntity.decode(entity.getData());
        if (msgEntity.getType() != 112) {
            throw new ProtocolException("\u8fd4\u56de\u7684messageType\u4e0d\u5339\u914d!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("devAddr", entity.getAddress());
        result.put("result", msgEntity.getResult());
        if (msgEntity.getData().length != 8) {
            throw new ProtocolException("\u8fd4\u56de\u7684messageData\u957f\u5ea6\u4e0d\u5339\u914d!");
        }
        byte[] data = msgEntity.getData();
        int value = 0;
        String key = "";
        key = "\u98ce\u91cf";
        value = (data[0] & 3) >> 0;
        if (value == 0) {
            result.put(key, "\u81ea\u52a8");
        }
        if (value == 1) {
            result.put(key, "\u9ad8");
        }
        if (value == 2) {
            result.put(key, "\u4e2d");
        }
        if (value == 3) {
            result.put(key, "\u4f4e");
        }
        key = "\u6a21\u5f0f";
        value = (data[0] & 0x30) >> 4;
        if (value == 0) {
            result.put(key, "\u5236\u70ed");
        }
        if (value == 1) {
            result.put(key, "\u9001\u98ce");
        }
        if (value == 2) {
            result.put(key, "\u5236\u51b7");
        }
        if (value == 3) {
            result.put(key, "\u9664\u6e7f");
        }
        key = "\u538b\u673a\u72b6\u6001";
        value = (data[0] & 0x40) >> 6;
        result.put(key, value == 1);
        key = "\u5f00\u5173\u72b6\u6001";
        value = (data[0] & 0x80) >> 7;
        result.put(key, value == 1);
        key = "\u8bbe\u5b9a\u6e29\u5ea6";
        value = data[2] & 0xFF;
        result.put(key, value);
        key = "\u5ba4\u5185\u6e29\u5ea6";
        value = data[3] & 0xFF;
        result.put(key, value);
        key = "\u7ba1\u6e29\u8fdb\u53e3AD\u503c";
        value = data[4] & 0xFF;
        result.put(key, value);
        key = "\u9664\u971c\u51fa\u53e3AD\u503c";
        value = data[5] & 0xFF;
        result.put(key, value);
        key = "\u9632\u51b7\u98ce(\u505c\u9001)";
        value = data[6] & 1 & 0xFF;
        result.put(key, value > 0);
        key = "\u9632\u51b7\u98ce(\u5fae\u98ce)";
        value = data[6] & 2 & 0xFF;
        result.put(key, value > 0);
        key = "\u8fc7\u70ed\u4fdd\u62a4";
        value = data[6] & 4 & 0xFF;
        result.put(key, value > 0);
        key = "\u8fc7\u51b7\u4fdd\u62a4";
        value = data[6] & 8 & 0xFF;
        result.put(key, value > 0);
        key = "\u7535\u8f85\u52a9\u52a0\u70ed\u6682\u505c";
        value = data[6] & 0x10 & 0xFF;
        result.put(key, value > 0);
        key = "\u5ba4\u5916\u673a\u4fdd\u62a4";
        value = data[6] & 0x20 & 0xFF;
        result.put(key, value > 0);
        key = "\u9664\u971c";
        value = data[6] & 0x40 & 0xFF;
        result.put(key, value > 0);
        key = "\u8fc7\u70ed\u505c\u673a";
        value = data[6] & 0x80 & 0xFF;
        result.put(key, value > 0);
        key = "\u5ba4\u5185\u6e29\u5ea6\u77ed\u8def\u6545\u969c";
        value = data[7] & 1 & 0xFF;
        result.put(key, value > 0);
        key = "\u5ba4\u5185\u6e29\u5ea6\u5f00\u6545\u969c";
        value = data[7] & 2 & 0xFF;
        result.put(key, value > 0);
        key = "\u5ba4\u5185\u7ba1\u6e29\u77ed\u8def\u6545\u969c";
        value = data[7] & 4 & 0xFF;
        result.put(key, value > 0);
        key = "\u5ba4\u5185\u7ba1\u6e29\u5f00\u8def\u6545\u969c";
        value = data[7] & 8 & 0xFF;
        result.put(key, value > 0);
        key = "\u5ba4\u5916\u7ba1\u6e29\u77ed\u8def\u6545\u969c";
        value = data[7] & 0x10 & 0xFF;
        result.put(key, value > 0);
        key = "\u5ba4\u5916\u7ba1\u6e29\u5f00\u8def\u6545\u969c";
        value = data[7] & 0x20 & 0xFF;
        result.put(key, value > 0);
        return result;
    }
}

