/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.tcl.air.adapter.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;

public class PduEntity {
    private int address = 0;
    private byte[] data = new byte[0];

    public static byte[] encodePdu(PduEntity entity) {
        byte[] data = new byte[entity.data.length + 4];
        int index = 0;
        data[index++] = (byte)(data.length - 2);
        data[index++] = (byte)(entity.address >> 8 & 0xFF);
        data[index++] = (byte)(entity.address >> 0 & 0xFF);
        System.arraycopy(entity.data, 0, data, index, entity.data.length);
        index += entity.data.length;
        data[index++] = PduEntity.getVerify(data);
        return PduEntity.encodePdu(data);
    }

    public static PduEntity decodePdu(byte[] pdu) {
        if (pdu == null || pdu.length < 4) {
            throw new ProtocolException("\u62a5\u6587\u5927\u5c0f\u5c0f\u4e8e4");
        }
        int headOffset = PduEntity.searchHead(pdu);
        if (headOffset == -1) {
            throw new ProtocolException("\u6ca1\u6709\u627e\u5230\u5305\u5934\uff1aF4 F5");
        }
        int tailOffset = PduEntity.searchTail(pdu, headOffset + 2);
        if (tailOffset == -1) {
            throw new ProtocolException("\u6ca1\u6709\u627e\u5230\u62a5\u5305\u5c3e\uff1aF4 FB");
        }
        byte[] dataArea = PduEntity.searchData(pdu, headOffset, tailOffset);
        if (dataArea.length < 4) {
            throw new ProtocolException("\u6d88\u606f\u7684\u6700\u5c0f\u957f\u5ea6\uff0c\u4e0d\u80fd\u5c0f\u4e8e4");
        }
        int index = 0;
        if (dataArea[index++] != dataArea.length - 2) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e!");
        }
        if (dataArea[dataArea.length - 1] != PduEntity.getVerify(dataArea)) {
            throw new ProtocolException("\u6821\u9a8c\u548c\u4e0d\u6b63\u786e!");
        }
        PduEntity entity = new PduEntity();
        entity.address = (dataArea[index++] & 0xFF) * 256 + (dataArea[index++] & 0xFF);
        entity.data = new byte[dataArea.length - 4];
        System.arraycopy(dataArea, index, entity.data, 0, entity.data.length);
        return entity;
    }

    private static int searchHead(byte[] pdu) {
        for (int i = 0; i < pdu.length - 1; ++i) {
            if (pdu[i] != -12 || pdu[i + 1] != -11) continue;
            return i;
        }
        return -1;
    }

    private static int searchTail(byte[] pdu, int offset) {
        for (int i = offset; i < pdu.length - 1; ++i) {
            if (pdu[i] == -12 && pdu[i + 1] == -12) {
                ++i;
                continue;
            }
            if (pdu[i] != -12 || pdu[i + 1] != -5) continue;
            return i;
        }
        return -1;
    }

    private static byte[] searchData(byte[] pdu, int headOffset, int tailOffset) {
        int length = 0;
        for (int i = headOffset + 2; i < tailOffset; ++i) {
            if (pdu[i] == -12 && pdu[i + 1] == -12) {
                ++i;
                ++length;
                continue;
            }
            ++length;
        }
        byte[] data = new byte[length];
        length = 0;
        for (int i = headOffset + 2; i < tailOffset; ++i) {
            data[length++] = pdu[i] == -12 && pdu[i + 1] == -12 ? pdu[++i] : pdu[i];
        }
        return data;
    }

    private static byte[] encodePdu(byte[] data) {
        int length = 0;
        for (int i = 0; i < data.length; ++i) {
            ++length;
            if (data[i] != -12) continue;
            ++length;
        }
        byte[] pdu = new byte[length + 4];
        pdu[0] = -12;
        pdu[1] = -11;
        for (int i = 0; i < data.length; ++i) {
            pdu[i + 2] = data[i];
            if (pdu[i + 2] != -12) continue;
            pdu[++i + 2] = -12;
        }
        pdu[pdu.length - 2] = -12;
        pdu[pdu.length - 1] = -5;
        return pdu;
    }

    private static byte getVerify(byte[] data) {
        int sum = 0;
        for (int i = 0; i < data.length - 1; ++i) {
            sum += data[i] & 0xFF;
        }
        return (byte)sum;
    }

    public int getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

