/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.s3p.core.entity;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.s3p.core.enums.Escape;
import cn.foxtech.device.protocol.v1.utils.Crc16Utils;

public class PduEntity {
    private int devAddr = 0;
    private int cmd = 0;
    private byte[] data = new byte[0];

    private static byte[] escapeDecode(byte[] srcData, Escape escape) {
        if (Escape.No.equals((Object)escape)) {
            return srcData;
        }
        if (srcData.length < 7) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u5c0f\u4e8e7");
        }
        if (srcData[0] != 126) {
            throw new ProtocolException("\u5305\u5934\u5fc5\u987b\u4e3a0x7E");
        }
        int dstLength = 1;
        for (int i = 1; i < srcData.length - 2; ++i) {
            if (srcData[i] != 125) {
                ++dstLength;
                continue;
            }
            if (++i >= srcData.length) {
                throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u5f02\u5e38");
            }
            if (srcData[i] == 94) {
                ++dstLength;
                continue;
            }
            if (srcData[i] == 93) {
                ++dstLength;
                continue;
            }
            if (srcData[i] >= 32) {
                ++dstLength;
                continue;
            }
            throw new ProtocolException("\u62a5\u6587\u5b57\u7b26\u7f16\u7801\u5f02\u5e38");
        }
        byte[] dstData = new byte[dstLength += 2];
        int index = 0;
        dstData[index++] = 126;
        boolean length = false;
        for (int i = 1; i < srcData.length - 2; ++i) {
            if (srcData[i] != 125) {
                dstData[index++] = srcData[i];
                continue;
            }
            if (++i >= srcData.length) {
                throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u5f02\u5e38");
            }
            if (srcData[i] == 94) {
                dstData[index++] = 126;
                continue;
            }
            if (srcData[i] == 93) {
                dstData[index++] = 125;
                continue;
            }
            if (srcData[i] >= 32) {
                dstData[index++] = (byte)(srcData[i] & 0x1F);
                continue;
            }
            throw new ProtocolException("\u62a5\u6587\u5b57\u7b26\u7f16\u7801\u5f02\u5e38");
        }
        dstData[dstData.length - 2] = srcData[srcData.length - 2];
        dstData[dstData.length - 1] = srcData[srcData.length - 1];
        return dstData;
    }

    private static byte[] escapeEncode(byte[] srcData, Escape escape) {
        if (Escape.No.equals((Object)escape)) {
            return srcData;
        }
        if (srcData.length < 7) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u5c0f\u4e8e7");
        }
        if (srcData[0] != 126) {
            throw new ProtocolException("\u5305\u5934\u5fc5\u987b\u4e3a0x7E");
        }
        int length = 1;
        for (int i = 1; i < srcData.length - 2; ++i) {
            if (srcData[i] == 126 && !Escape.No.equals((Object)escape)) {
                length += 2;
                continue;
            }
            if (srcData[i] == 125 && !Escape.No.equals((Object)escape)) {
                length += 2;
                continue;
            }
            if (srcData[i] < 32 && Escape.Max.equals((Object)escape)) {
                length += 2;
                continue;
            }
            ++length;
        }
        byte[] dstData = new byte[length += 2];
        int index = 0;
        dstData[index++] = 126;
        for (int i = 1; i < srcData.length - 2; ++i) {
            if (srcData[i] == 126 && !Escape.No.equals((Object)escape)) {
                dstData[index++] = 125;
                dstData[index++] = 94;
                continue;
            }
            if (srcData[i] == 125 && !Escape.No.equals((Object)escape)) {
                dstData[index++] = 125;
                dstData[index++] = 93;
                continue;
            }
            if (srcData[i] < 32 && Escape.Max.equals((Object)escape)) {
                dstData[index++] = 125;
                byte byAt = srcData[i];
                byAt = (byte)(byAt | 0x20);
                dstData[index++] = byAt;
                continue;
            }
            dstData[index++] = srcData[i];
        }
        dstData[dstData.length - 2] = srcData[srcData.length - 2];
        dstData[dstData.length - 1] = srcData[srcData.length - 1];
        return dstData;
    }

    public static PduEntity decodePdu(byte[] pdu) {
        return PduEntity.decodePdu(pdu, Escape.Min);
    }

    public static PduEntity decodePdu(byte[] pdu, Escape escape) {
        int length;
        int nSize = (pdu = PduEntity.escapeDecode(pdu, escape)).length;
        if (nSize < 7) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u5c0f\u4e8e7");
        }
        int index = 0;
        if (pdu[index++] != 126) {
            throw new ProtocolException("\u5305\u5934\u5fc5\u987b\u4e3a0x7E");
        }
        PduEntity entity = new PduEntity();
        entity.devAddr = pdu[index++] & 255 + pdu[index++] << 8 & 0xFF;
        entity.cmd = pdu[index++] & 0xFF;
        if (pdu.length < (length = pdu[index++] & 0xFF) + 7) {
            throw new ProtocolException("\u957f\u5ea6\u4e0d\u6b63\u786e!");
        }
        if (Crc16Utils.getCRC16((byte[])pdu, (int)0, (int)(length + 7), (int)4129, (int)0, (int)0, (boolean)false) != 0) {
            throw new ProtocolException("CRC\u6821\u9a8c\u4e0d\u6b63\u786e");
        }
        entity.data = new byte[length];
        System.arraycopy(pdu, 5, entity.data, 0, entity.data.length);
        return entity;
    }

    public static byte[] encodePdu(PduEntity entity, Escape escape) {
        if (entity.data.length > 255) {
            throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u4e86255");
        }
        byte[] pdu = new byte[entity.data.length + 7];
        int index = 0;
        pdu[index++] = 126;
        pdu[index++] = (byte)(entity.devAddr / 256);
        pdu[index++] = (byte)(entity.devAddr % 256);
        pdu[index++] = (byte)entity.cmd;
        pdu[index++] = (byte)entity.data.length;
        System.arraycopy(entity.data, 0, pdu, index, entity.data.length);
        index += entity.data.length;
        int crc = Crc16Utils.getCRC16((byte[])pdu, (int)0, (int)(pdu.length - 2), (int)4129, (int)0, (int)0, (boolean)false);
        pdu[index++] = (byte)(crc >> 8 & 0xFF);
        pdu[index++] = (byte)(crc >> 0 & 0xFF);
        return PduEntity.escapeEncode(pdu, escape);
    }

    public int getDevAddr() {
        return this.devAddr;
    }

    public int getCmd() {
        return this.cmd;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setDevAddr(int devAddr) {
        this.devAddr = devAddr;
    }

    public void setCmd(int cmd) {
        this.cmd = cmd;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

