/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.opcua.template;

import cn.foxtech.device.protocol.v1.core.context.ApplicationContext;
import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.core.template.ITemplate;
import cn.foxtech.device.protocol.v1.opcua.entity.OpcUaNodeId;
import cn.foxtech.device.protocol.v1.utils.MethodUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDefaultTemplate
implements ITemplate {
    public static final String FORMAT_NAME = "default";
    private JDecoderParam decoderParam = new JDecoderParam();

    public String getSysTemplateName() {
        return FORMAT_NAME;
    }

    public void loadJsnModel(String modelName) {
        Map deviceTemplateEntity = ApplicationContext.getDeviceModels((String)modelName);
        Long updateTime = deviceTemplateEntity.getOrDefault("updateTime", 0L);
        if (this.decoderParam.updateTime.equals(updateTime)) {
            return;
        }
        Map modelParam = deviceTemplateEntity.getOrDefault("modelParam", new HashMap());
        List rows = modelParam.getOrDefault("list", new ArrayList());
        HashMap<String, JDecoderValueParam> nameMap = new HashMap<String, JDecoderValueParam>();
        HashMap<OpcUaNodeId, JDecoderValueParam> nodeMap = new HashMap<OpcUaNodeId, JDecoderValueParam>();
        for (Map row : rows) {
            JDecoderValueParam jDecoderValueParam = new JDecoderValueParam();
            jDecoderValueParam.setObject_name((String)row.get("object_name"));
            jDecoderValueParam.setNode_id_identifier((String)row.get("node_id_identifier"));
            jDecoderValueParam.setNode_id_namespace(Integer.parseInt(row.get("node_id_namespace").toString()));
            jDecoderValueParam.setRemark((String)row.get("remark"));
            if (MethodUtils.hasEmpty((Object[])new Object[]{jDecoderValueParam.object_name, jDecoderValueParam.node_id_namespace, jDecoderValueParam.node_id_identifier})) continue;
            OpcUaNodeId nodeId = new OpcUaNodeId();
            nodeId.setNamespace(jDecoderValueParam.node_id_namespace);
            nodeId.setIdentifier(jDecoderValueParam.node_id_identifier);
            nameMap.put(jDecoderValueParam.getObject_name(), jDecoderValueParam);
            nodeMap.put(nodeId, jDecoderValueParam);
        }
        this.decoderParam.nameMap = nameMap;
        this.decoderParam.nodeMap = nodeMap;
        this.decoderParam.table = modelName;
        this.decoderParam.updateTime = updateTime;
    }

    public OpcUaNodeId encodeNodeId(String objectName) {
        JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.decoderParam.nameMap.get(objectName);
        if (jDecoderValueParam == null) {
            throw new ProtocolException("csv\u4e2d\u672a\u5b9a\u4e49\u8be5\u5bf9\u8c61\u7684\u4fe1\u606f:" + objectName);
        }
        OpcUaNodeId nodeId = new OpcUaNodeId();
        nodeId.setNamespace(jDecoderValueParam.node_id_namespace);
        nodeId.setIdentifier(jDecoderValueParam.node_id_identifier);
        return nodeId;
    }

    public List<OpcUaNodeId> encodeNodeIdList(List<String> objectNameList) {
        ArrayList<OpcUaNodeId> nodeIdList = new ArrayList<OpcUaNodeId>();
        for (String objectName : objectNameList) {
            JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.decoderParam.nameMap.get(objectName);
            if (jDecoderValueParam == null) {
                throw new ProtocolException("csv\u4e2d\u672a\u5b9a\u4e49\u8be5\u5bf9\u8c61\u7684\u4fe1\u606f:" + objectName);
            }
            OpcUaNodeId nodeId = new OpcUaNodeId();
            nodeId.setNamespace(jDecoderValueParam.node_id_namespace);
            nodeId.setIdentifier(jDecoderValueParam.node_id_identifier);
            nodeIdList.add(nodeId);
        }
        return nodeIdList;
    }

    public String getObjectName(OpcUaNodeId nodeId) {
        JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.decoderParam.nodeMap.get(nodeId);
        if (jDecoderValueParam == null) {
            return null;
        }
        return jDecoderValueParam.object_name;
    }

    public Map<String, Object> decodeValue(Map<String, Object> nodeId2Value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String nodeId : nodeId2Value.keySet()) {
            Object value = nodeId2Value.get(nodeId);
            JDecoderValueParam jDecoderValueParam = (JDecoderValueParam)this.decoderParam.nodeMap.get(nodeId);
            if (jDecoderValueParam == null) {
                throw new ProtocolException("csv\u4e2d\u672a\u5b9a\u4e49\u8be5\u5bf9\u8c61\u7684\u4fe1\u606f:" + nodeId);
            }
            result.put(jDecoderValueParam.getObject_name(), value);
        }
        return result;
    }

    public JDecoderParam getDecoderParam() {
        return this.decoderParam;
    }

    public void setDecoderParam(JDecoderParam decoderParam) {
        this.decoderParam = decoderParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JDefaultTemplate)) {
            return false;
        }
        JDefaultTemplate other = (JDefaultTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JDecoderParam this$decoderParam = this.getDecoderParam();
        JDecoderParam other$decoderParam = other.getDecoderParam();
        return !(this$decoderParam == null ? other$decoderParam != null : !((Object)this$decoderParam).equals(other$decoderParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JDefaultTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JDecoderParam $decoderParam = this.getDecoderParam();
        result = result * 59 + ($decoderParam == null ? 43 : ((Object)$decoderParam).hashCode());
        return result;
    }

    public String toString() {
        return "JDefaultTemplate(decoderParam=" + this.getDecoderParam() + ")";
    }

    public static class JDecoderValueParam
    implements Serializable {
        private String object_name;
        private Integer node_id_namespace;
        private String node_id_identifier;
        private String remark;

        public String getObject_name() {
            return this.object_name;
        }

        public Integer getNode_id_namespace() {
            return this.node_id_namespace;
        }

        public String getNode_id_identifier() {
            return this.node_id_identifier;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setObject_name(String object_name) {
            this.object_name = object_name;
        }

        public void setNode_id_namespace(Integer node_id_namespace) {
            this.node_id_namespace = node_id_namespace;
        }

        public void setNode_id_identifier(String node_id_identifier) {
            this.node_id_identifier = node_id_identifier;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderValueParam)) {
                return false;
            }
            JDecoderValueParam other = (JDecoderValueParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$node_id_namespace = this.getNode_id_namespace();
            Integer other$node_id_namespace = other.getNode_id_namespace();
            if (this$node_id_namespace == null ? other$node_id_namespace != null : !((Object)this$node_id_namespace).equals(other$node_id_namespace)) {
                return false;
            }
            String this$object_name = this.getObject_name();
            String other$object_name = other.getObject_name();
            if (this$object_name == null ? other$object_name != null : !this$object_name.equals(other$object_name)) {
                return false;
            }
            String this$node_id_identifier = this.getNode_id_identifier();
            String other$node_id_identifier = other.getNode_id_identifier();
            if (this$node_id_identifier == null ? other$node_id_identifier != null : !this$node_id_identifier.equals(other$node_id_identifier)) {
                return false;
            }
            String this$remark = this.getRemark();
            String other$remark = other.getRemark();
            return !(this$remark == null ? other$remark != null : !this$remark.equals(other$remark));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderValueParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $node_id_namespace = this.getNode_id_namespace();
            result = result * 59 + ($node_id_namespace == null ? 43 : ((Object)$node_id_namespace).hashCode());
            String $object_name = this.getObject_name();
            result = result * 59 + ($object_name == null ? 43 : $object_name.hashCode());
            String $node_id_identifier = this.getNode_id_identifier();
            result = result * 59 + ($node_id_identifier == null ? 43 : $node_id_identifier.hashCode());
            String $remark = this.getRemark();
            result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
            return result;
        }

        public String toString() {
            return "JDefaultTemplate.JDecoderValueParam(object_name=" + this.getObject_name() + ", node_id_namespace=" + this.getNode_id_namespace() + ", node_id_identifier=" + this.getNode_id_identifier() + ", remark=" + this.getRemark() + ")";
        }
    }

    public static class JDecoderParam
    implements Serializable {
        private String table;
        private Object updateTime = 0L;
        private Map<String, JDecoderValueParam> nameMap = new HashMap<String, JDecoderValueParam>();
        private Map<OpcUaNodeId, JDecoderValueParam> nodeMap = new HashMap<OpcUaNodeId, JDecoderValueParam>();

        public String getTable() {
            return this.table;
        }

        public Object getUpdateTime() {
            return this.updateTime;
        }

        public Map<String, JDecoderValueParam> getNameMap() {
            return this.nameMap;
        }

        public Map<OpcUaNodeId, JDecoderValueParam> getNodeMap() {
            return this.nodeMap;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public void setUpdateTime(Object updateTime) {
            this.updateTime = updateTime;
        }

        public void setNameMap(Map<String, JDecoderValueParam> nameMap) {
            this.nameMap = nameMap;
        }

        public void setNodeMap(Map<OpcUaNodeId, JDecoderValueParam> nodeMap) {
            this.nodeMap = nodeMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderParam)) {
                return false;
            }
            JDecoderParam other = (JDecoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            Object this$updateTime = this.getUpdateTime();
            Object other$updateTime = other.getUpdateTime();
            if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
                return false;
            }
            Map<String, JDecoderValueParam> this$nameMap = this.getNameMap();
            Map<String, JDecoderValueParam> other$nameMap = other.getNameMap();
            if (this$nameMap == null ? other$nameMap != null : !((Object)this$nameMap).equals(other$nameMap)) {
                return false;
            }
            Map<OpcUaNodeId, JDecoderValueParam> this$nodeMap = this.getNodeMap();
            Map<OpcUaNodeId, JDecoderValueParam> other$nodeMap = other.getNodeMap();
            return !(this$nodeMap == null ? other$nodeMap != null : !((Object)this$nodeMap).equals(other$nodeMap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            Object $updateTime = this.getUpdateTime();
            result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
            Map<String, JDecoderValueParam> $nameMap = this.getNameMap();
            result = result * 59 + ($nameMap == null ? 43 : ((Object)$nameMap).hashCode());
            Map<OpcUaNodeId, JDecoderValueParam> $nodeMap = this.getNodeMap();
            result = result * 59 + ($nodeMap == null ? 43 : ((Object)$nodeMap).hashCode());
            return result;
        }

        public String toString() {
            return "JDefaultTemplate.JDecoderParam(table=" + this.getTable() + ", updateTime=" + this.getUpdateTime() + ", nameMap=" + this.getNameMap() + ", nodeMap=" + this.getNodeMap() + ")";
        }
    }

    public static class JEncoderParam
    implements Serializable {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JEncoderParam)) {
                return false;
            }
            JEncoderParam other = (JEncoderParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JEncoderParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "JDefaultTemplate.JEncoderParam(name=" + this.getName() + ")";
        }
    }
}

