/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.opcua.entity;

import java.util.Map;
import java.util.Objects;

public class OpcUaNodeId {
    private Integer namespace;
    private String identifier;

    public static OpcUaNodeId buildEntity(Integer namespace, String identifier) {
        if (namespace == null || identifier == null) {
            return null;
        }
        OpcUaNodeId result = new OpcUaNodeId();
        result.setNamespace(namespace);
        result.setIdentifier(identifier);
        return result;
    }

    public static OpcUaNodeId buildEntity(Map<String, Object> nodeIdMap) {
        if (nodeIdMap == null) {
            return null;
        }
        Integer namespace = (Integer)nodeIdMap.get("namespace");
        String identifier = (String)nodeIdMap.get("identifier");
        return OpcUaNodeId.buildEntity(namespace, identifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpcUaNodeId nodeId = (OpcUaNodeId)o;
        return Objects.equals(this.namespace, nodeId.namespace) && Objects.equals(this.identifier, nodeId.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.identifier);
    }

    public String toString() {
        return "NodeId:[" + this.namespace + ":" + this.identifier + "]";
    }

    public Integer getNamespace() {
        return this.namespace;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setNamespace(Integer namespace) {
        this.namespace = namespace;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

