/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.opcua;

import cn.foxtech.device.protocol.core.annotation.FoxEdgeDeviceType;
import cn.foxtech.device.protocol.core.annotation.FoxEdgeOperate;
import cn.foxtech.device.protocol.core.exception.ProtocolException;
import cn.foxtech.device.protocol.core.template.TemplateFactory;
import cn.foxtech.device.protocol.core.utils.MethodUtils;
import cn.foxtech.device.protocol.opcua.entity.OpcUaNodeId;
import cn.foxtech.device.protocol.opcua.template.JDefaultTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FoxEdgeDeviceType(value="OPC-UA", manufacturer="Fox Edge")
public class OpcUaBrowseChildValue {
    @FoxEdgeOperate(name="\u8bfb\u5b50\u8282\u70b9\u6570\u503c", polling=true, type="encoder", timeout=2000)
    public static Map<String, Object> packBrowseChildValue(Map<String, Object> param) {
        String objectName = (String)param.get("objectName");
        String tableName = (String)param.get("tableName");
        String templateName = (String)param.get("templateName");
        if (MethodUtils.hasNull((Object[])new Object[]{objectName, templateName, tableName})) {
            throw new ProtocolException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:objectName, templateName, tableName");
        }
        JDefaultTemplate template = (JDefaultTemplate)TemplateFactory.getTemplate((String)"fox-edge-server-protocol-snmp").getTemplate(templateName, tableName, JDefaultTemplate.class);
        OpcUaNodeId nodeId = template.encodeNodeId(objectName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("operate", "browseChildValue");
        result.put("nodeId", nodeId);
        return result;
    }

    @FoxEdgeOperate(name="\u8bfb\u5b50\u8282\u70b9\u6570\u503c", polling=true, type="decoder", timeout=2000)
    public static Map<String, Object> unpackReadData(Map<String, Object> respond, Map<String, Object> param) {
        String tableName = (String)param.get("tableName");
        String templateName = (String)param.get("templateName");
        if (MethodUtils.hasNull((Object[])new Object[]{templateName, tableName})) {
            throw new ProtocolException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a:templateName, tableName");
        }
        JDefaultTemplate template = (JDefaultTemplate)TemplateFactory.getTemplate((String)"fox-edge-server-protocol-snmp").getTemplate(templateName, tableName, JDefaultTemplate.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List children = (List)respond.get("children");
        for (Map child : children) {
            String objectName;
            OpcUaNodeId nodeId = OpcUaNodeId.buildEntity((Map)child.get("nodeId"));
            if (nodeId == null || (objectName = template.getObjectName(nodeId)) == null) continue;
            result.put(objectName, child.get("value"));
        }
        return result;
    }
}

