/*
 * Decompiled with CFR 0.152.
 */
package cn.foxtech.device.protocol.v1.omron.fins.core.encoder;

import cn.foxtech.device.protocol.v1.core.exception.ProtocolException;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.ConnectRequest;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.ConnectRespond;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.Header;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.OmronFinsPdu;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.Transfer;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.TransferRequest;
import cn.foxtech.device.protocol.v1.omron.fins.core.entity.pdu.TransferRespond;

public class PduEncoder {
    private static long getLong(byte[] pack, int index) {
        long value = 0L;
        value += (long)((pack[index + 3] & 0xFF) * 1);
        value += (long)((pack[index + 2] & 0xFF) * 256);
        value += (long)((pack[index + 1] & 0xFF) * 65536);
        return value += (long)((pack[index + 0] & 0xFF) * 0x1000000);
    }

    private static void setLong(byte[] pack, int index, long value) {
        pack[index + 3] = (byte)(value & 0xFFL);
        pack[index + 2] = (byte)(value >> 8 & 0xFFL);
        pack[index + 1] = (byte)(value >> 16 & 0xFFL);
        pack[index + 0] = (byte)(value >> 24 & 0xFFL);
    }

    public static byte[] encodePduPack(OmronFinsPdu entity) {
        byte[] pack = new byte[entity.getData().length + 16];
        PduEncoder.setLong(pack, 0, 1179209299L);
        PduEncoder.setLong(pack, 4, entity.getData().length + 8);
        PduEncoder.setLong(pack, 8, entity.getCommand());
        PduEncoder.setLong(pack, 12, entity.getError());
        System.arraycopy(entity.getData(), 0, pack, 16, entity.getData().length);
        return pack;
    }

    public static OmronFinsPdu decodePduPack(byte[] pack) {
        if (pack.length < 16) {
            throw new ProtocolException("\u8fd4\u56de\u6570\u636e\u957f\u5ea6\u81f3\u5c1112\u5b57\u8282");
        }
        long header = PduEncoder.getLong(pack, 0);
        if (header != 1179209299L) {
            throw new ProtocolException("header\u4e0d\u6b63\u786e!");
        }
        long length = PduEncoder.getLong(pack, 4);
        if (length > 65536L) {
            throw new ProtocolException("\u62a5\u6587\u592a\u957f\uff0c\u4e0d\u652f\u6301\u8be5\u62a5\u6587!");
        }
        if ((long)pack.length != length + 8L) {
            throw new ProtocolException("\u62a5\u6587\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
        }
        long command = PduEncoder.getLong(pack, 8);
        if (command != 0L && command != 1L && command != 2L) {
            throw new ProtocolException("\u547d\u4ee4\u7801\u4e0d\u6b63\u786e\uff01");
        }
        long errorCode = PduEncoder.getLong(pack, 12);
        byte[] data = new byte[pack.length - 16];
        System.arraycopy(pack, 16, data, 0, data.length);
        OmronFinsPdu entity = new OmronFinsPdu();
        entity.setCommand((int)command);
        entity.setError((int)errorCode);
        entity.setData(data);
        return entity;
    }

    public static byte[] encodePduPack(ConnectRequest session) {
        OmronFinsPdu entity = new OmronFinsPdu();
        entity.setCommand(0);
        entity.setData(new byte[4]);
        PduEncoder.setLong(entity.getData(), 0, session.getClientNode());
        return PduEncoder.encodePduPack(entity);
    }

    public static byte[] encodePduPack(Transfer transfer) {
        byte[] data = new byte[12 + transfer.getData().length];
        Header header = transfer.getHeader();
        data[0] = (byte)header.getICF();
        data[1] = (byte)header.getRSV();
        data[2] = (byte)header.getGCT();
        data[3] = (byte)header.getDNA();
        data[4] = (byte)header.getDA1();
        data[5] = (byte)header.getDA2();
        data[6] = (byte)header.getSNA();
        data[7] = (byte)header.getSA1();
        data[8] = (byte)header.getSA2();
        data[9] = (byte)header.getSID();
        data[10] = (byte)transfer.getMrc();
        data[11] = (byte)transfer.getSrc();
        System.arraycopy(transfer.getData(), 0, data, 12, transfer.getData().length);
        OmronFinsPdu entity = new OmronFinsPdu();
        entity.setCommand(2);
        entity.setError(0);
        entity.setData(data);
        return PduEncoder.encodePduPack(entity);
    }

    public static <T> T decodePdu(byte[] pack, Class<T> clazz) {
        OmronFinsPdu entity = PduEncoder.decodePduPack(pack);
        if (ConnectRequest.class.equals(clazz)) {
            if (entity.getCommand() != 0) {
                throw new ProtocolException("\u4e0d\u5339\u914d\u7684\u62a5\u6587!");
            }
            ConnectRequest session = new ConnectRequest();
            if (entity.getData().length != 4) {
                throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
            }
            session.setClientNode((int)PduEncoder.getLong(entity.getData(), 0));
            return (T)session;
        }
        if (ConnectRespond.class.equals(clazz)) {
            if (entity.getCommand() != 1) {
                throw new ProtocolException("\u4e0d\u5339\u914d\u7684\u62a5\u6587!");
            }
            ConnectRespond session = new ConnectRespond();
            if (entity.getData().length != 8) {
                throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
            }
            session.setClientNode((int)PduEncoder.getLong(entity.getData(), 0));
            session.setServerNode((int)PduEncoder.getLong(entity.getData(), 4));
            return (T)session;
        }
        if (TransferRequest.class.equals(clazz) || TransferRespond.class.equals(clazz)) {
            if (entity.getCommand() != 2) {
                throw new ProtocolException("\u4e0d\u5339\u914d\u7684\u62a5\u6587!");
            }
            if (entity.getData().length < 12) {
                throw new ProtocolException("\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e\uff01");
            }
            byte[] data = entity.getData();
            Transfer transfer = null;
            if (clazz.equals(TransferRequest.class)) {
                transfer = new TransferRequest();
            }
            if (clazz.equals(TransferRespond.class)) {
                transfer = new TransferRespond();
            }
            Header header = new Header();
            header.setICF(data[0] & 0xFF);
            header.setRSV(data[1] & 0xFF);
            header.setGCT(data[2] & 0xFF);
            header.setDNA(data[3] & 0xFF);
            header.setDA1(data[4] & 0xFF);
            header.setDA2(data[5] & 0xFF);
            header.setSNA(data[6] & 0xFF);
            header.setSA1(data[7] & 0xFF);
            header.setSA2(data[8] & 0xFF);
            header.setSID(data[9] & 0xFF);
            transfer.setHeader(header);
            transfer.setMrc(data[10] & 0xFF);
            transfer.setSrc(data[11] & 0xFF);
            byte[] sdata = new byte[data.length - 12];
            transfer.setData(sdata);
            System.arraycopy(data, 12, sdata, 0, sdata.length);
            return (T)transfer;
        }
        throw new ProtocolException("\u8fd9\u4e0d\u662f\u5339\u914d\u7684PDU\u7c7b\u578b!");
    }
}

